/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.client;

import static org.mule.runtime.http.api.HttpConstants.HttpStatus.OK;
import static org.mule.service.http.test.netty.AllureConstants.HttpStory.MAX_CONNECTIONS;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import io.qameta.allure.Story;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import java.util.ArrayList;
import java.util.List;

@Story(MAX_CONNECTIONS)
public class HttpRequesterQuickConnectionCloseTestCase extends AbstractHttpClientTestCase {

  private static int NUMBER_OF_REQUESTS = 50;

  private HttpClient client;

  private List<HttpResponse> responses = new ArrayList<>(NUMBER_OF_REQUESTS);

  private List<Throwable> errors = new ArrayList<>(NUMBER_OF_REQUESTS);

  public HttpRequesterQuickConnectionCloseTestCase(String serviceToLoad) {
    super(serviceToLoad);
  }

  @BeforeEach
  public void createClient() throws CreateException {
    client = service.getClientFactory().create(new HttpClientConfiguration.Builder()
        .setMaxConnections(1)
        .setName("http-requester-quick-connection-close")
        .build());
    client.start();
  }

  @AfterEach
  public void stopClient() {
    if (client != null) {
      client.stop();
    }
  }

  @Test
  void test() {
    for (int i = 0; i < NUMBER_OF_REQUESTS; i++) {
      HttpResponse response;
      try {
        response = client.send(getRequest());
        responses.add(response);
      } catch (Throwable e) {
        errors.add(e);
      }
    }
    assertThat(responses.size(), is(NUMBER_OF_REQUESTS));
    assertThat(errors.size(), is(0));
  }

  @Override
  protected HttpResponse setUpHttpResponse(HttpRequest request) {
    return HttpResponse.builder()
        .statusCode(OK.getStatusCode())
        .reasonPhrase(OK.getReasonPhrase())
        .build();
  }

  private HttpRequest getRequest() {
    return HttpRequest.builder().uri(getUri()).build();
  }

}
