/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

/**
 * If a server is created within a Mule Application, it is expected to be only visible in the context of the same Mule
 * Application. If it is created in a Mule Domain, it has to be visible from the domain itself, and from any Mule Application
 * belonging to it. This identifier contains the information needed to implement that logic in
 * {@link HttpServerConnectionManager}.
 *
 * @param serverName the name of the server. In the HTTP Connector, it is the same as the listener-config.
 * @param context    the name of the context that created the server (usually the deployable artifact name).
 */
public record ServerIdentifier(String serverName, String context) {
}
