/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import org.mule.service.http.netty.impl.streaming.StatusCallback;

import java.io.InputStream;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;

/**
 * Implementation of {@link ChannelFutureListener} to be used when a streaming response is completely written. It closes the
 * {@link InputStream} passed as constructor parameter and calls the {@link StatusCallback}.
 */
public class FinishStreamingListener implements ChannelFutureListener {

  private final InputStream streamToClose;
  private final StatusCallback statusCallback;

  public FinishStreamingListener(InputStream streamToClose, StatusCallback statusCallback) {
    this.streamToClose = streamToClose;
    this.statusCallback = statusCallback;
  }

  @Override
  public void operationComplete(ChannelFuture channelFuture) throws Exception {
    try {
      streamToClose.close();
    } finally {
      if (channelFuture.isSuccess()) {
        statusCallback.onSuccess();
      } else {
        statusCallback.onFailure(channelFuture.cause());
      }
    }
  }
}
