/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.common.server.sse;

import static org.mule.runtime.http.api.sse.server.SseClientConfig.builderFrom;

import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseRequestContext;

import java.util.function.Consumer;

/**
 * Server side SSE endpoint.
 */
public class SseRequestHandler implements RequestHandler {

  private final Consumer<SseRequestContext> onRequest;
  private final Consumer<SseClient> onSseClient;

  public SseRequestHandler(Consumer<SseRequestContext> onRequest,
                           Consumer<SseClient> onSseClient) {
    this.onRequest = onRequest;
    this.onSseClient = onSseClient;
  }

  @Override
  public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
    SseRequestContextImpl context = new SseRequestContextImpl(requestContext, responseCallback);
    onRequest.accept(context);
    if (context.isResponded()) {
      return;
    }

    var clientConfig = builderFrom(requestContext)
        .withClientId(context.getClientId().orElse(null))
        .customizeResponse(context.getResponseCustomizer())
        .build();
    var sseClient = new SseResponseStarter().startResponse(clientConfig, responseCallback);
    onSseClient.accept(sseClient);
  }
}
