/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.netty.impl.server.ChannelPromises;
import org.mule.service.http.netty.impl.server.HttpWriter;
import org.mule.service.http.netty.impl.server.ResponseSender;
import org.mule.service.http.netty.impl.streaming.StatusCallback;

public abstract class BaseResponseSender
implements ResponseSender {
    protected final HttpRequest request;
    protected final HttpResponse response;
    private final ChannelHandlerContext ctx;
    private final StatusCallback statusCallback;
    private final HttpWriter writer;
    private boolean headerAlreadySent;

    protected BaseResponseSender(HttpRequest request, ChannelHandlerContext ctx, HttpResponse response, StatusCallback statusCallback, HttpWriter writer) {
        this.writer = writer;
        Preconditions.checkArgument((statusCallback != null ? 1 : 0) != 0, (String)"statusCallback can't be null");
        this.request = request;
        this.response = response;
        this.ctx = ctx;
        this.statusCallback = statusCallback;
    }

    @Override
    public void send() throws IOException {
        this.headerAlreadySent = false;
        this.sendContent();
    }

    protected void sendHeaderIfNeeded() {
        if (!this.headerAlreadySent) {
            this.writer.writeResponseHeader(this.request, this.response, ChannelPromises.promiseToCallback(this.ctx, this.statusCallback, false));
            this.headerAlreadySent = true;
        }
    }

    protected ByteBuf createBuffer(int size) {
        return this.ctx.alloc().buffer(size, size);
    }

    protected void sendLastContentAndFinishStreaming(ByteBuf content, InputStream contentAsInputStream) {
        this.sendHeaderIfNeeded();
        this.writer.writeContent(content, true, ChannelPromises.finishStreamingPromise(this.ctx, contentAsInputStream, this.statusCallback));
    }

    protected abstract void sendContent() throws IOException;
}

