/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.junit.jupiter.api.DisplayName;

@DisplayName("Validates that the POST body is preserved on NTLM authentication")
public class NtlmHttpClientPostStreamingTestCase extends AbstractNtlmHttpClientPostStreamingTestCase {

  public NtlmHttpClientPostStreamingTestCase(String serviceToLoad) {
    super(serviceToLoad);
  }

  @Override
  protected InputStream getInputStream() {
    return new ByteArrayInputStream(TEST_PAYLOAD.getBytes());
  }

}
