/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.util;

import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.HttpService;

import java.lang.reflect.InvocationTargetException;

public class ReflectiveServiceFactory {

  public static HttpService createHttpService(String httpServiceClass, SchedulerService schedulerService)
      throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException,
      ClassNotFoundException {
    return (HttpService) Class.forName(httpServiceClass, true, ReflectiveServiceFactory.class.getClassLoader())
        .getConstructor(SchedulerService.class).newInstance(schedulerService);
  }
}
