/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.common.server.sse;

import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.sse.server.SseResponseCustomizer;

public class SseResponseCustomizerImpl implements SseResponseCustomizer {

  private final HttpResponseBuilder responseBuilder;

  public SseResponseCustomizerImpl(HttpResponseBuilder responseBuilder) {
    this.responseBuilder = responseBuilder;
  }

  @Override
  public SseResponseCustomizer addResponseHeader(String name, String value) {
    responseBuilder.addHeader(name, value);
    return this;
  }
}
