/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.request.ClientConnection;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.domain.request.ServerConnection;

import java.net.InetSocketAddress;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;

public class NettyHttpRequestContext implements HttpRequestContext {

  private final HttpRequest request;
  private final NettyServerConnection serverConnection;
  private final NettyClientConnection clientConnection;
  private final String scheme;

  public NettyHttpRequestContext(HttpRequest request, ChannelHandlerContext ctx, SslHandler sslHandler) {
    this.request = request;
    this.serverConnection = new NettyServerConnection((InetSocketAddress) ctx.channel().localAddress());
    this.clientConnection = new NettyClientConnection((InetSocketAddress) ctx.channel().remoteAddress(), sslHandler);
    this.scheme = sslHandler != null ? "https" : "http";
  }

  @Override
  public String getScheme() {
    return scheme;
  }

  @Override
  public HttpRequest getRequest() {
    return request;
  }

  @Override
  public ServerConnection getServerConnection() {
    return serverConnection;
  }

  @Override
  public ClientConnection getClientConnection() {
    return clientConnection;
  }
}
