/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message.content;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.FeedableHttpEntity;
import org.mule.service.http.netty.impl.streaming.BlockingBidirectionalStream;
import org.mule.service.http.netty.impl.streaming.CancelableOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyFeedableHttpEntity
implements FeedableHttpEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyFeedableHttpEntity.class);
    private static final long UNKNOWN_CONTENT_LENGTH = -1L;
    private final InputStream asInputStream;
    private final CancelableOutputStream dataSink;
    private final long contentLength;
    private final CompletableFuture<MultiMap<String, String>> futureTrailers;

    public NettyFeedableHttpEntity() {
        this(-1L);
    }

    public NettyFeedableHttpEntity(long contentLength) {
        BlockingBidirectionalStream bidirectionalStream = new BlockingBidirectionalStream();
        this.asInputStream = bidirectionalStream.getInputStream();
        this.dataSink = bidirectionalStream.getOutputStream();
        this.contentLength = contentLength;
        this.futureTrailers = new CompletableFuture();
    }

    public boolean isStreaming() {
        return true;
    }

    public InputStream getContent() {
        return this.asInputStream;
    }

    public byte[] getBytes() throws IOException {
        return IOUtils.toByteArray((InputStream)this.asInputStream);
    }

    public Optional<Long> getLength() {
        return this.contentLength == -1L ? Optional.empty() : Optional.of(this.contentLength);
    }

    public OptionalLong getBytesLength() {
        return this.contentLength == -1L ? OptionalLong.empty() : OptionalLong.of(this.contentLength);
    }

    public void feed(ByteBuffer data) throws IOException {
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        LOGGER.debug("Feeding entity with {} bytes", (Object)bytes.length);
        this.dataSink.write(bytes, 0, bytes.length);
    }

    public void error(Exception exception) {
        LOGGER.debug("Marking entity with error", (Throwable)exception);
        this.dataSink.cancel(exception);
    }

    public void complete() throws IOException {
        this.completeWithTrailers((MultiMap<String, String>)MultiMap.emptyMultiMap());
    }

    public synchronized void completeWithTrailers(MultiMap<String, String> trailers) throws IOException {
        LOGGER.atDebug().log(() -> "Completing HTTP entity with {} trailers" + trailers.size());
        this.futureTrailers.complete(trailers);
        this.dataSink.close();
    }

    public void onComplete(BiConsumer<? super MultiMap<String, String>, ? super Throwable> completionCallback) {
        LOGGER.debug("Registering a callback for the entity completion");
        this.futureTrailers.whenComplete(completionCallback);
    }
}

