/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.http2;

import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.netty.AllureConstants;
import org.mule.tck.junit5.DynamicPort;

import io.qameta.allure.Feature;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

@Feature(AllureConstants.HTTP_2)
public abstract class AbstractHttp2ClientServerTestCase extends AbstractHttpServiceTestCase {

  @DynamicPort(systemProperty = "http.port")
  private Integer port;

  protected HttpServer server;

  protected HttpClient client;

  public AbstractHttp2ClientServerTestCase(String serviceToLoad) {
    super(serviceToLoad);
  }

  @BeforeEach
  void setUp() throws Exception {
    var serverConfig = new HttpServerConfiguration.Builder()
        .setHost("localhost").setPort(port)
        .setName("HTTP/2 Server")
        .setHttp1Config(new Http1ProtocolConfig(false))
        .setHttp2Config(new Http2ProtocolConfig(true))
        .build();
    server = service.getServerFactory().create(serverConfig);
    server.start();

    var clientConfig = new HttpClientConfiguration.Builder()
        .setName("HTTP/2 Client")
        .setHttp1Config(new Http1ProtocolConfig(false))
        .setHttp2Config(new Http2ProtocolConfig(true))
        .build();
    client = service.getClientFactory().create(clientConfig);
    client.start();
  }

  @AfterEach
  void tearDown() {
    if (server != null) {
      server.stop();
      server.dispose();
    }
    if (client != null) {
      client.stop();
    }
  }
}
