/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import java.io.IOException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.netty.impl.util.HttpResponseCreatorUtils;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;

class EchoLikeRequestHandler
implements RequestHandler {
    EchoLikeRequestHandler() {
    }

    public void handleRequest(HttpRequestContext reqCtx, HttpResponseReadyCallback callback) {
        HttpResponse response = this.generateResponse(reqCtx);
        callback.responseReady(response, (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
    }

    private HttpResponse generateResponse(HttpRequestContext reqCtx) {
        try {
            HttpEntity echoBody = this.generateResponseBody(reqCtx);
            return ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(200)).entity(echoBody)).build();
        }
        catch (Exception e) {
            return ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(500)).entity((HttpEntity)new StringHttpEntity("Error: " + e.getMessage()))).build();
        }
    }

    private HttpEntity generateResponseBody(HttpRequestContext reqCtx) throws Exception {
        HttpRequest req = reqCtx.getRequest();
        String body = this.extractBodyAsString(req);
        String queryParams = req.getQueryParams().toString();
        String uriString = req.getUri().toString();
        MultiMap trailers = (MultiMap)HttpResponseCreatorUtils.trailersAsFuture((HttpEntity)req.getEntity()).get();
        return new StringHttpEntity("Request{\n  body: %s,\n  uri: %s,\n  queryParams: %s\n  trailers: %s\n}\n".formatted(body, uriString, queryParams, trailers.toString()));
    }

    private String extractBodyAsString(HttpRequest request) {
        try {
            return new String(request.getEntity().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

