/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.tck.junit5.DynamicPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Feature(value="HTTP/2 Support")
@Issue(value="W-19860076")
class Http2ReverseProxyMultiplexingTestCase
extends AbstractHttpServiceTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2ReverseProxyMultiplexingTestCase.class);
    private static final String BACKEND_ENDPOINT = "/test";
    private static final int TOTAL_REQUESTS = 1000;
    private static final int HTTP2_UNLIMITED_EFFECTIVE_MAX = 500;
    private static final int CUSTOMER_MAX_CONNECTIONS = 12;
    @DynamicPort(systemProperty="backendPort")
    private Integer backendPort;
    private HttpServer backendServer;
    private HttpClient testClient;
    private ExecutorService requestHandlerExecutor;
    private final Set<String> uniqueConnectionIdentifiers = Collections.newSetFromMap(new ConcurrentHashMap());
    private CountDownLatch requestLatch;
    private CountDownLatch requestsArrivedLatch;
    private volatile int concurrentRequestsInServer = 0;
    private volatile int maxConcurrentRequestsSeen = 0;

    public Http2ReverseProxyMultiplexingTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setUp() {
        this.uniqueConnectionIdentifiers.clear();
    }

    @AfterEach
    void tearDown() {
        if (this.testClient != null) {
            this.testClient.stop();
        }
        if (this.backendServer != null) {
            this.backendServer.stop();
            this.backendServer.dispose();
        }
        if (this.requestHandlerExecutor != null) {
            this.requestHandlerExecutor.shutdownNow();
        }
    }

    @Test
    @Description(value="HTTP/1.1 baseline: Uses one connection per concurrent request (no multiplexing).")
    void testHttp1BaselineConnection() throws Exception {
        this.startServer(true, false);
        this.startClient(true, false, 1000);
        this.runLoadTest(1000);
        int connections = this.uniqueConnectionIdentifiers.size();
        LOGGER.info("[Test 1] HTTP/1.1: {} connections created", (Object)connections);
        MatcherAssert.assertThat((String)"HTTP/1.1 should use ~1 connection per concurrent request (no multiplexing)", (Object)connections, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(800)));
    }

    @Test
    @Description(value="HTTP/2 (Unlimited): Should multiplex efficiently and keep connections low.")
    void testHttp2UnlimitedConnection() throws Exception {
        this.startServer(false, true);
        this.startClient(false, true, -1);
        this.runLoadTest(1000);
        int connections = this.uniqueConnectionIdentifiers.size();
        LOGGER.info("[Test 2] HTTP/2 Unlimited: {} connections created", (Object)connections);
        MatcherAssert.assertThat((String)"HTTP/2 should multiplex efficiently over a small pool of connections", (Object)connections, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(400)));
    }

    @Test
    @Description(value="HTTP/2 (Limited): Should respect explicit maxConnections and multiplex efficiently.")
    void testHttp2LimitedConnection() throws Exception {
        this.startServer(false, true);
        this.startClient(false, true, 12);
        this.runLoadTest(1000);
        int connections = this.uniqueConnectionIdentifiers.size();
        LOGGER.info("[Test 3] HTTP/2 Limited: {} connections created", (Object)connections);
        MatcherAssert.assertThat((String)"Should adhere to maxConnections limit and multiplex efficiently", (Object)connections, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(12 + Math.max(1, 0))));
    }

    @Test
    @Description(value="HTTP/2 (Single Connection): Should handle 10 requests over exactly 1 connection with 10 max streams.")
    void testHttp2SingleConnectionWithLimitedStreams() throws Exception {
        int requestCount = 10;
        this.startServer(false, true, requestCount);
        this.testClient = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("TestClient").setHttp1Config(new Http1ProtocolConfig(false)).setHttp2Config(new Http2ProtocolConfig(true).setMaxConcurrentStreams(Long.valueOf(10L))).setUsePersistentConnections(true).setMaxConnections(1).build());
        this.testClient.start();
        this.runLoadTest(requestCount);
        int connections = this.uniqueConnectionIdentifiers.size();
        LOGGER.info("[Test 4] HTTP/2 Single Connection: {} connections created for {} requests with 10 max streams", (Object)connections, (Object)requestCount);
        MatcherAssert.assertThat((String)"Should handle all requests over exactly 1 connection", (Object)connections, (Matcher)Matchers.is((Object)1));
    }

    private void runLoadTest(int requestCount) throws Exception {
        String url = "http://localhost:" + this.backendPort + BACKEND_ENDPOINT;
        HttpRequest request = HttpRequest.builder().uri(url).method("GET").build();
        HttpRequestOptions options = HttpRequestOptions.builder().responseTimeout(30000).build();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(requestCount);
        for (int i = 0; i < requestCount; ++i) {
            futures.add(this.testClient.sendAsync(request, options));
        }
        if (!this.requestsArrivedLatch.await(10L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Not all requests arrived at the server within timeout");
        }
        MatcherAssert.assertThat((String)"All requests should be handled concurrently", (Object)this.maxConcurrentRequestsSeen, (Matcher)Matchers.is((Object)requestCount));
        this.requestLatch.countDown();
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(25L, TimeUnit.SECONDS);
        int successCount = 0;
        for (CompletableFuture future : futures) {
            if (((HttpResponse)future.get()).getStatusCode() != 200) continue;
            ++successCount;
        }
        MatcherAssert.assertThat((String)"All requests must succeed", (Object)successCount, (Matcher)Matchers.is((Object)requestCount));
    }

    private void startServer(boolean h1, boolean h2) throws Exception {
        this.startServer(h1, h2, 1000);
    }

    private void startServer(boolean h1, boolean h2, int expectedRequestCount) throws Exception {
        if (this.backendServer != null) {
            this.backendServer.stop();
            this.backendServer.dispose();
        }
        if (this.requestHandlerExecutor != null) {
            this.requestHandlerExecutor.shutdownNow();
        }
        this.requestLatch = new CountDownLatch(1);
        this.requestsArrivedLatch = new CountDownLatch(expectedRequestCount);
        this.concurrentRequestsInServer = 0;
        this.maxConcurrentRequestsSeen = 0;
        this.requestHandlerExecutor = Executors.newFixedThreadPool(expectedRequestCount);
        this.backendServer = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setName("Backend").setHost("localhost").setPort(this.backendPort.intValue()).setHttp1Config(new Http1ProtocolConfig(h1)).setHttp2Config(new Http2ProtocolConfig(h2)).build());
        this.backendServer.start();
        this.backendServer.addRequestHandler(BACKEND_ENDPOINT, (reqCtx, callback) -> {
            String remoteAddress = reqCtx.getClientConnection().getRemoteHostAddress().toString();
            this.uniqueConnectionIdentifiers.add(remoteAddress);
            this.requestHandlerExecutor.submit(() -> {
                try {
                    Http2ReverseProxyMultiplexingTestCase http2ReverseProxyMultiplexingTestCase = this;
                    synchronized (http2ReverseProxyMultiplexingTestCase) {
                        ++this.concurrentRequestsInServer;
                        this.maxConcurrentRequestsSeen = Math.max(this.maxConcurrentRequestsSeen, this.concurrentRequestsInServer);
                    }
                    this.requestsArrivedLatch.countDown();
                    this.requestLatch.await();
                    callback.responseReady(((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(200)).entity((HttpEntity)new ByteArrayHttpEntity("OK".getBytes()))).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    Http2ReverseProxyMultiplexingTestCase http2ReverseProxyMultiplexingTestCase = this;
                    synchronized (http2ReverseProxyMultiplexingTestCase) {
                        --this.concurrentRequestsInServer;
                    }
                }
            });
        });
    }

    private void startClient(boolean h1, boolean h2, int maxConnections) {
        if (this.testClient != null) {
            this.testClient.stop();
        }
        this.testClient = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("TestClient").setHttp1Config(new Http1ProtocolConfig(h1)).setHttp2Config(new Http2ProtocolConfig(h2)).setUsePersistentConnections(true).setMaxConnections(maxConnections).build());
        this.testClient.start();
    }
}

