/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message;

import io.netty.handler.codec.http.HttpResponse;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.netty.impl.message.ReactorNettyResponseWrapper;
import org.mule.service.http.netty.impl.util.HttpResponseCreatorUtils;
import reactor.netty.http.client.HttpClientResponse;

public class HttpResponseCreator {
    private static final String HEADER_CONTENT_TYPE = "Content-Type".toLowerCase();
    private static final String HEADER_CONTENT_LENGTH = "Content-Length".toLowerCase();
    private final HttpResponseCreatorUtils httpResponseCreatorUtils = new HttpResponseCreatorUtils();

    public org.mule.runtime.http.api.domain.message.response.HttpResponse create(HttpResponse response, InputStream inputStream) {
        HttpResponseBuilder responseBuilder = this.httpResponseCreatorUtils.buildResponseHeaders(response);
        String contentType = this.httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_TYPE);
        String contentLength = this.httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_LENGTH);
        responseBuilder.entity(HttpResponseCreatorUtils.createEntity(inputStream, contentType, contentLength, response.status().code(), CompletableFuture.completedFuture(MultiMap.emptyMultiMap())));
        return responseBuilder.build();
    }

    public org.mule.runtime.http.api.domain.message.response.HttpResponse create(HttpClientResponse response, InputStream inputStream) {
        int statusCode = response.status().code();
        String contentType = this.httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_TYPE);
        String contentLength = this.httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_LENGTH);
        HttpEntity entity = HttpResponseCreatorUtils.createEntity(inputStream, contentType, contentLength, statusCode, HttpResponseCreatorUtils.trailersAsFuture(response));
        return new ReactorNettyResponseWrapper(response, entity);
    }
}

