/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.message;

import static java.nio.ByteBuffer.wrap;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.anEmptyMap;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.api.util.MultiMap;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;

import java.util.concurrent.CompletableFuture;

import org.junit.jupiter.api.Test;

class FeedableHttpEntityTestCase extends AbstractHttpServiceTestCase {

  public static final String HELLO = "Hello ";
  public static final String WORLD = "world!";
  public static final String HELLO_WORLD = HELLO + WORLD;

  public FeedableHttpEntityTestCase(String serviceToLoad) {
    super(serviceToLoad);
  }

  @Test
  void feedContentAndFinish() throws Exception {
    var entityFactory = service.getEntityFactory();

    var feedableEntity = entityFactory.feedable();
    feedableEntity.feed(wrap(HELLO.getBytes()));
    feedableEntity.feed(wrap(WORLD.getBytes()));
    feedableEntity.complete();

    String out = new String(feedableEntity.getBytes());
    assertThat(out, is(HELLO_WORLD));

    var futureTrailers = new CompletableFuture<MultiMap<String, String>>();
    feedableEntity.onComplete((trailers, throwable) -> {
      if (throwable != null) {
        futureTrailers.completeExceptionally(throwable);
      } else {
        futureTrailers.complete(trailers);
      }
    });
    var trailers = futureTrailers.get();
    assertThat(trailers.isEmpty(), is(true));
    assertThat(trailers, is(anEmptyMap()));
  }
}
