/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.message.content;

import org.mule.runtime.http.api.domain.entity.HttpEntity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public class StringHttpEntity implements HttpEntity {

  private final String asString;
  private final ByteArrayInputStream asStream;

  public StringHttpEntity(String asString) {
    this.asString = asString;
    this.asStream = new ByteArrayInputStream(asString.getBytes());
  }


  @Override
  public boolean isStreaming() {
    return false;
  }

  @Override
  public InputStream getContent() {
    return asStream;
  }

  @Override
  public byte[] getBytes() throws IOException {
    return asString.getBytes();
  }

  @Override
  public Optional<Long> getLength() {
    return Optional.of(Long.valueOf(asString.length()));
  }
}
