/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;

import java.util.concurrent.Executor;

import io.netty.channel.ChannelHandler.Sharable;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.ssl.SslHandler;

/**
 * Initializes new instances of {@link Http2StreamChannel} by adding a {@link NettyToMuleHttp2RequestHandlerAdapter} to its
 * pipeline, which will delegate the requests to the received {@link HttpListenerRegistry}.
 */
@Sharable
public class MultiplexerChannelInitializer extends ChannelInitializer<Http2StreamChannel> {

  private final HttpListenerRegistry httpListenerRegistry;
  private final SslHandler sslHandler;
  private final Executor ioExecutor;

  public MultiplexerChannelInitializer(HttpListenerRegistry httpListenerRegistry, SslHandler sslHandler, Executor ioExecutor) {
    this.httpListenerRegistry = httpListenerRegistry;
    this.sslHandler = sslHandler;
    this.ioExecutor = ioExecutor;
  }

  @Override
  protected void initChannel(Http2StreamChannel http2StreamChannel) {
    http2StreamChannel.pipeline().addLast("Delegate to Service",
                                          new NettyToMuleHttp2RequestHandlerAdapter(httpListenerRegistry, sslHandler,
                                                                                    ioExecutor));
  }
}
