/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ConnectionsCounterHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionsCounterHandler.class);
    private int connectionsCount;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.incrementConnectionsCount();
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.decrementConnectionsCount();
    }

    private synchronized void incrementConnectionsCount() {
        ++this.connectionsCount;
    }

    private synchronized void decrementConnectionsCount() {
        --this.connectionsCount;
        ((Object)((Object)this)).notifyAll();
    }

    public boolean waitForConnectionsToBeClosed(String serverName, long timeout, TimeUnit unit) {
        LOGGER.debug("Waiting for {} milliseconds for connections of HTTP server {} to be closed...", (Object)this.connectionsCount, (Object)serverName);
        this.doWaitForConnectionsToBeClosed(serverName, timeout, unit);
        if (this.connectionsCount > 0) {
            LOGGER.warn("There are still {} open connections on server {} stop.", (Object)this.connectionsCount, (Object)serverName);
            return false;
        }
        LOGGER.debug("There are no more open connections on server {} stop.", (Object)serverName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWaitForConnectionsToBeClosed(String serverName, long timeout, TimeUnit unit) {
        if (timeout == 0L) {
            return;
        }
        long stopNanos = System.nanoTime() + unit.toNanos(timeout);
        ConnectionsCounterHandler connectionsCounterHandler = this;
        synchronized (connectionsCounterHandler) {
            try {
                long remainingNanos = stopNanos - System.nanoTime();
                while (this.connectionsCount > 0 && remainingNanos > 0L) {
                    long remainingMillis = TimeUnit.NANOSECONDS.toMillis(remainingNanos);
                    long millisToWait = Math.min(remainingMillis, 50L);
                    LOGGER.debug("There are still {} open connections on server {} stop. Waiting for {} milliseconds...", new Object[]{this.connectionsCount, serverName, millisToWait});
                    if (millisToWait > 0L) {
                        ((Object)((Object)this)).wait(millisToWait);
                    } else {
                        ((Object)((Object)this)).wait(0L, (int)remainingNanos);
                    }
                    remainingNanos = stopNanos - System.nanoTime();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

