/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server.util;

import static org.mule.runtime.http.api.HttpConstants.HttpStatus.REQUEST_URI_TOO_LONG;

/**
 * A request handler that returns a "Request URI Too Long" (414) error response. This handler is used when the URI of the request
 * exceeds the server's allowed limit.
 */
public class HeaderTooLongRequestHandler extends ErrorRequestHandler {

  private static final HeaderTooLongRequestHandler instance = new HeaderTooLongRequestHandler();

  private HeaderTooLongRequestHandler() {
    super(REQUEST_URI_TOO_LONG.getStatusCode(), REQUEST_URI_TOO_LONG.getReasonPhrase(), "Request too long to '%s'");
  }

  public static HeaderTooLongRequestHandler getInstance() {
    return instance;
  }
}
