/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.message;

import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.util.MultiMap;
import org.mule.service.http.netty.impl.message.content.NettyFeedableHttpEntity;
import org.mule.service.http.test.common.AbstractHttpTestCase;

@Story(value="HTTP/2 Reactive")
public class FeedableHttpEntityTestCase
extends AbstractHttpTestCase {
    public static final String HELLO = "Hello ";
    public static final String WORLD = "world!";
    public static final String HELLO_WORLD = "Hello world!";

    @Test
    void lengthDependsOnParameter() {
        NettyFeedableHttpEntity entityKnownLength = new NettyFeedableHttpEntity(10L);
        MatcherAssert.assertThat((Object)entityKnownLength.getBytesLength().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)entityKnownLength.getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)10L));
        NettyFeedableHttpEntity entityUnknownLength = new NettyFeedableHttpEntity();
        MatcherAssert.assertThat((Object)entityUnknownLength.getBytesLength().isPresent(), (Matcher)Matchers.is((Object)false));
        NettyFeedableHttpEntity entityLengthMinusOne = new NettyFeedableHttpEntity(-1L);
        MatcherAssert.assertThat((Object)entityLengthMinusOne.getBytesLength().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void contentCanBeConsumedAsStream() throws IOException {
        byte[] originalBytes = "Hello test!".getBytes();
        NettyFeedableHttpEntity entity = new NettyFeedableHttpEntity();
        entity.feed(ByteBuffer.wrap(originalBytes));
        entity.complete();
        byte[] readBytes = IOUtils.toByteArray((InputStream)entity.getContent());
        MatcherAssert.assertThat((Object)readBytes, (Matcher)Matchers.is((Object)originalBytes));
    }

    @Test
    void contentCanBeConsumedAsReactive() throws IOException, ExecutionException, InterruptedException {
        String originalString = "Hello test!";
        NettyFeedableHttpEntity entity = new NettyFeedableHttpEntity();
        entity.feed(ByteBuffer.wrap(originalString.getBytes()));
        entity.complete();
        StringBuilder stringBuilder = new StringBuilder();
        CompletableFuture aggregatedPayload = new CompletableFuture();
        entity.onData(data -> stringBuilder.append(StandardCharsets.UTF_8.decode((ByteBuffer)data)));
        entity.onComplete((ts, err) -> aggregatedPayload.complete(stringBuilder.toString()));
        MatcherAssert.assertThat((Object)((String)aggregatedPayload.get()), (Matcher)Matchers.is((Object)originalString));
    }

    @Test
    void whenBeingConsumedAsStream_canNotBeConsumedAsReactive() {
        NettyFeedableHttpEntity entity = new NettyFeedableHttpEntity();
        entity.getContent();
        IllegalStateException error = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> entity.onData(data -> {}));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.is((Object)"This entity is being consumed as an input stream"));
    }

    @Test
    void whenBeingConsumedAsReactive_canNotBeConsumedAsStream() {
        NettyFeedableHttpEntity entity = new NettyFeedableHttpEntity();
        entity.onData(data -> {});
        IllegalStateException error = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((NettyFeedableHttpEntity)entity).getContent());
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.is((Object)"This entity is being consumed reactively"));
    }

    @Test
    void cannotRegisterTwoReactiveDataConsumers() {
        NettyFeedableHttpEntity entity = new NettyFeedableHttpEntity();
        entity.onData(data -> {});
        IllegalStateException error = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> entity.onData(data -> {}));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.is((Object)"A consumer has already been registered for this entity"));
    }

    @Test
    void feedContentAndFinish() throws Exception {
        NettyFeedableHttpEntity feedableEntity = new NettyFeedableHttpEntity();
        feedableEntity.feed(ByteBuffer.wrap(HELLO.getBytes()));
        feedableEntity.feed(ByteBuffer.wrap(WORLD.getBytes()));
        feedableEntity.complete();
        String out = new String(feedableEntity.getBytes());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.is((Object)HELLO_WORLD));
        CompletableFuture futureTrailers = new CompletableFuture();
        feedableEntity.onComplete((trailers, throwable) -> {
            if (throwable != null) {
                futureTrailers.completeExceptionally((Throwable)throwable);
            } else {
                futureTrailers.complete(trailers);
            }
        });
        MultiMap trailers2 = (MultiMap)futureTrailers.get();
        MatcherAssert.assertThat((Object)trailers2.isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)trailers2, (Matcher)Matchers.is((Matcher)Matchers.anEmptyMap()));
    }

    @Test
    void tryFeedingAfterCompletionFails() {
        NettyFeedableHttpEntity feedableEntity = new NettyFeedableHttpEntity();
        feedableEntity.complete();
        IOException error = (IOException)Assertions.assertThrows(IOException.class, () -> feedableEntity.feed(ByteBuffer.wrap(HELLO.getBytes())));
        MatcherAssert.assertThat((Object)error, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"This entity is already completed")));
    }

    @Test
    void tryFeedingAfterCompletionWithTrailersFails() {
        NettyFeedableHttpEntity feedableEntity = new NettyFeedableHttpEntity();
        MultiMap.StringMultiMap trailers = new MultiMap.StringMultiMap();
        trailers.put((Object)"status", (Object)"blah");
        feedableEntity.completeWithTrailers((MultiMap)trailers);
        IOException error = (IOException)Assertions.assertThrows(IOException.class, () -> feedableEntity.feed(ByteBuffer.wrap(HELLO.getBytes())));
        MatcherAssert.assertThat((Object)error, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"This entity is already completed")));
    }

    @Test
    void tryFeedingAfterErrorFails() {
        NettyFeedableHttpEntity feedableEntity = new NettyFeedableHttpEntity();
        NullPointerException userError = new NullPointerException("EXPECTED");
        feedableEntity.error((Exception)userError);
        NullPointerException error = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> feedableEntity.feed(ByteBuffer.wrap(HELLO.getBytes())));
        MatcherAssert.assertThat((Object)error, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"EXPECTED")));
    }

    @Test
    void errorAfterCompleteFails() {
        NettyFeedableHttpEntity feedableEntity = new NettyFeedableHttpEntity();
        NullPointerException userError = new NullPointerException("ERROR AFTER COMPLETE");
        feedableEntity.complete();
        IllegalStateException error = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> feedableEntity.error((Exception)userError));
        MatcherAssert.assertThat((Object)error, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"This entity is already completed")));
    }

    @Test
    void secondErrorInvocationFails() {
        NettyFeedableHttpEntity feedableEntity = new NettyFeedableHttpEntity();
        NullPointerException firstError = new NullPointerException("USER ERROR");
        feedableEntity.error((Exception)firstError);
        NullPointerException secondError = new NullPointerException("ILLEGAL ERROR");
        IllegalStateException invocationError = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> feedableEntity.error((Exception)secondError));
        MatcherAssert.assertThat((Object)invocationError, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"This entity has already been marked with an error")));
        MatcherAssert.assertThat((Object)invocationError, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"USER ERROR"))));
    }

    @Test
    void secondCompleteFails() {
        NettyFeedableHttpEntity feedableEntity = new NettyFeedableHttpEntity();
        feedableEntity.complete();
        IllegalStateException error = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((NettyFeedableHttpEntity)feedableEntity).complete());
        MatcherAssert.assertThat((Object)error, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"This entity is already completed")));
    }
}

