/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.entity.Feedable;
import org.mule.runtime.http.api.domain.entity.FeedableHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServerProperties;
import reactor.netty.http.client.HttpClientResponse;

public class ReactorNettyResponseWrapper
implements HttpResponse,
Feedable {
    private final HttpClientResponse response;
    private final HttpEntity entity;
    private final LazyValue<MultiMap<String, String>> headersAsMultiMap;
    private final Feedable feedableDelegate;

    public ReactorNettyResponseWrapper(HttpClientResponse response, FeedableHttpEntity entity) {
        this(response, (HttpEntity)entity, (Feedable)entity);
    }

    public ReactorNettyResponseWrapper(HttpClientResponse response, HttpEntity entity, Feedable feedableDelegate) {
        this.response = response;
        this.entity = entity;
        this.headersAsMultiMap = new LazyValue(() -> ReactorNettyResponseWrapper.headersToMultiMap(response.responseHeaders()));
        this.feedableDelegate = feedableDelegate;
    }

    public int getStatusCode() {
        return this.response.status().code();
    }

    public String getReasonPhrase() {
        return this.response.status().reasonPhrase();
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public Collection<String> getHeaderNames() {
        return this.response.responseHeaders().names();
    }

    public String getHeaderValue(String headerName) {
        return this.response.responseHeaders().getAsString((CharSequence)headerName);
    }

    public String getHeaderValueIgnoreCase(String headerName) {
        return this.response.responseHeaders().getAsString((CharSequence)headerName);
    }

    public Collection<String> getHeaderValues(String headerName) {
        return this.response.responseHeaders().getAll(headerName);
    }

    public Collection<String> getHeaderValuesIgnoreCase(String headerName) {
        return this.response.responseHeaders().getAll(headerName);
    }

    public MultiMap<String, String> getHeaders() {
        return (MultiMap)this.headersAsMultiMap.get();
    }

    private static MultiMap<String, String> headersToMultiMap(HttpHeaders nettyHeaders) {
        CaseInsensitiveMultiMap asMultiMap = new CaseInsensitiveMultiMap(!HttpServerProperties.PRESERVE_HEADER_CASE);
        nettyHeaders.iteratorAsString().forEachRemaining(header -> asMultiMap.put((Object)((String)header.getKey()), (Object)((String)header.getValue())));
        return asMultiMap;
    }

    public void feed(ByteBuffer nioBuffer) throws IOException {
        this.feedableDelegate.feed(nioBuffer);
    }

    public void error(Exception exception) {
        this.feedableDelegate.error(exception);
    }

    public void complete() throws IOException {
        this.feedableDelegate.complete();
    }

    public void completeWithTrailers(MultiMap<String, String> trailers) throws IOException {
        this.feedableDelegate.completeWithTrailers(trailers);
    }
}

