/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.util;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.netty.impl.message.content.StreamedMultipartHttpEntity;
import reactor.netty.http.client.HttpClientResponse;

public class HttpResponseCreatorUtils {
    public static HttpEntity createEntity(InputStream stream, String contentType, long contentLength, int statusCode, CompletableFuture<MultiMap<String, String>> futureTrailers) {
        if (HttpResponseCreatorUtils.isMultipartMixed(contentType)) {
            return HttpResponseCreatorUtils.createMultipartEntity(stream, contentLength, contentType, futureTrailers);
        }
        if (contentLength > 0L) {
            return new InputStreamHttpEntity(stream, contentLength, futureTrailers);
        }
        if (contentLength == 0L || HttpResponseCreatorUtils.isEmptyResponseStatus(statusCode)) {
            return new EmptyHttpEntity(futureTrailers);
        }
        return new InputStreamHttpEntity(stream, futureTrailers);
    }

    public static String extractHeader(HttpResponse response, String headerName) {
        HttpHeaders headers = response.headers();
        return headers.contains(headerName) ? headers.get(headerName) : null;
    }

    public static String extractHeader(HttpClientResponse response, String headerName) {
        HttpHeaders headers = response.responseHeaders();
        return headers.get(headerName);
    }

    public static HttpResponseBuilder buildResponseHeaders(HttpResponse response) {
        HttpResponseBuilder responseBuilder = org.mule.runtime.http.api.domain.message.response.HttpResponse.builder().statusCode(Integer.valueOf(response.status().code())).reasonPhrase(response.status().reasonPhrase());
        HttpHeaders headers = response.headers();
        if (!headers.isEmpty()) {
            headers.names().forEach(headerName -> responseBuilder.addHeaders(headerName, (Collection)headers.getAll(headerName)));
        }
        return responseBuilder;
    }

    public static CompletableFuture<MultiMap<String, String>> trailersAsFuture(HttpClientResponse response) {
        CompletableFuture<MultiMap<String, String>> trailersFuture = new CompletableFuture<MultiMap<String, String>>();
        response.trailerHeaders().toFuture().whenComplete((trailers, throwable) -> {
            if (throwable != null) {
                trailersFuture.completeExceptionally((Throwable)throwable);
            } else {
                MultiMap.StringMultiMap asMultiMap = new MultiMap.StringMultiMap();
                for (Map.Entry trailer : trailers) {
                    asMultiMap.put((Object)((String)trailer.getKey()), (Object)((String)trailer.getValue()));
                }
                trailersFuture.complete((MultiMap<String, String>)asMultiMap);
            }
        });
        return trailersFuture;
    }

    public static CompletableFuture<MultiMap<String, String>> trailersAsFuture(HttpEntity httpEntity) {
        CompletableFuture<MultiMap<String, String>> completableFuture = new CompletableFuture<MultiMap<String, String>>();
        httpEntity.onComplete((entity, throwable) -> {
            if (throwable != null) {
                completableFuture.completeExceptionally((Throwable)throwable);
            } else {
                completableFuture.complete((MultiMap<String, String>)entity);
            }
        });
        return completableFuture;
    }

    public static long parseContentLength(String contentLength) {
        return contentLength != null ? Long.parseLong(contentLength) : -1L;
    }

    public static boolean isMultipartMixed(String contentType) {
        return contentType != null && contentType.startsWith(MediaType.MULTIPART_MIXED.getPrimaryType());
    }

    public static HttpEntity createMultipartEntity(InputStream stream, long contentLengthAsLong, String contentType, CompletableFuture<MultiMap<String, String>> futureTrailers) {
        return contentLengthAsLong >= 0L ? new StreamedMultipartHttpEntity(stream, contentType, contentLengthAsLong, futureTrailers) : new StreamedMultipartHttpEntity(stream, contentType, futureTrailers);
    }

    public static boolean isEmptyResponseStatus(int statusCode) {
        return statusCode == HttpConstants.HttpStatus.NO_CONTENT.getStatusCode() || statusCode == HttpConstants.HttpStatus.NOT_MODIFIED.getStatusCode() || statusCode == HttpConstants.HttpStatus.RESET_CONTENT.getStatusCode();
    }
}

