/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.streaming;

import static org.mule.runtime.api.util.Preconditions.checkArgument;

import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.server.BaseResponseSender;
import org.mule.service.http.netty.impl.server.HttpWriter;
import org.mule.service.http.netty.impl.server.ResponseSender;

import java.io.IOException;

import io.netty.channel.ChannelHandlerContext;

/**
 * Implementation of {@link ResponseSender} that sends a response using a {@link ReactiveEntitySender} for the entity.
 */
public class ReactiveResponseSender extends BaseResponseSender {

  private static final Runnable NO_OP = () -> {
  };

  private final ReactiveEntitySender entitySender;

  public ReactiveResponseSender(HttpRequest request, ChannelHandlerContext ctx, HttpResponse response,
                                ResponseStatusCallback statusCallback, HttpWriter writer) {
    super(request, ctx, response, new ResponseStatusCallbackAdapter(statusCallback), writer);
    checkArgument(response.getEntity().isReactive(), "Response entity must be reactive to use a ReactiveResponseSender");
    entitySender =
        new ReactiveEntitySender(response.getEntity(), ctx, NO_OP, new ResponseStatusCallbackAdapter(statusCallback), writer);
  }

  @Override
  protected void sendContent() throws IOException {
    sendHeaderIfNeeded();
    entitySender.start();
  }
}
