/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.qameta.allure.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http.nio.support.classic.AbstractClassicEntityProducer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.Issue;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.client.sse.FillAndWaitStream;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;

@Feature(value="HTTP/2 Support")
class Http2ServerClientDisconnectTestCase
extends AbstractHttpServerTestCase {
    private static final String TEST_ENDPOINT = "/test";
    private static final int SMALL_TIMEOUT_MS = 1000;
    private static final int CONN_IDLE_TIMEOUT_MS = 1000;
    private static final int CONN_READ_TIMEOUT_MS = 300;
    private final Latch requestReceived = new Latch();
    private final Latch requestCanComplete = new Latch();

    public Http2ServerClientDisconnectTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    protected boolean getHttp1Support() {
        return false;
    }

    @Override
    protected String getServerName() {
        return "HTTP/2 Server";
    }

    @Override
    protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder builder) {
        return builder.setReadTimeout(300L).setConnectionIdleTimeout(1000).setHttp1Config(new Http1ProtocolConfig(this.getHttp1Support())).setHttp2Config(new Http2ProtocolConfig(true));
    }

    @BeforeEach
    void setUp() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler(TEST_ENDPOINT, (reqCtx, callback) -> {
            this.requestReceived.release();
            this.getSchedulerService().ioScheduler().submit(() -> {
                try {
                    this.requestCanComplete.await(1000L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                callback.responseReady(HttpResponse.builder().build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
            });
        });
    }

    @Test
    @Issue(value="W-19861068")
    void whenClientDisconnectsThenServerClosesConnection() throws Exception {
        try (CloseableHttpAsyncClient h2Client = HttpAsyncClients.createHttp2Default();){
            h2Client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath(TEST_ENDPOINT));
            this.requestCanComplete.release();
            h2Client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
        }
        this.assertNoActiveConnections();
    }

    @Test
    @Issue(value="W-19861068")
    void whenClientDisconnectsDuringRequestThenServerClosesConnection() throws Exception {
        try (CloseableHttpAsyncClient h2Client = HttpAsyncClients.createHttp2Default();){
            h2Client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath(TEST_ENDPOINT));
            h2Client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback());
            MatcherAssert.assertThat((String)"Request was not received", (Object)this.requestReceived.await(1000L, TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
            h2Client.close();
            this.requestCanComplete.release();
        }
        this.assertNoActiveConnections();
    }

    @Test
    @Issue(value="W-19861068")
    void whenClientIsIdleAfterTimeoutThenServerClosesConnection() throws Exception {
        try (CloseableHttpAsyncClient h2Client = HttpAsyncClients.createHttp2Default();){
            h2Client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath(TEST_ENDPOINT));
            this.requestCanComplete.release();
            h2Client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            Thread.sleep(1100L);
            this.assertNoActiveConnections();
        }
    }

    @Test
    @Issue(value="W-19861068")
    void whenReadTimeoutThenServerClosesConnection() throws Exception {
        try (CloseableHttpAsyncClient h2Client = HttpAsyncClients.createHttp2Default();){
            h2Client.start();
            HttpPost request = new HttpPost(this.urlForPath(TEST_ENDPOINT));
            Latch finishRequest = new Latch();
            FillAndWaitStream inputStream = new FillAndWaitStream(finishRequest);
            Future respFuture = h2Client.execute((AsyncRequestProducer)new InputStreamRequestProducer((HttpRequest)request, inputStream, ContentType.TEXT_PLAIN, (Executor)this.getSchedulerService().ioScheduler()), (AsyncResponseConsumer)SimpleResponseConsumer.create(), new AbstractHttpServiceTestCase.IgnoreFutureCallback());
            Thread.sleep(400L);
            SimpleHttpResponse resp = (SimpleHttpResponse)respFuture.get();
            MatcherAssert.assertThat((Object)resp.getCode(), (Matcher)Matchers.is((Object)HttpResponseStatus.REQUEST_TIMEOUT.code()));
            MatcherAssert.assertThat((Object)resp.getBodyText(), (Matcher)Matchers.is((Object)"Timeout reading request"));
            finishRequest.release();
            this.requestCanComplete.release();
        }
        this.assertNoActiveConnections();
    }

    private void assertNoActiveConnections() {
        AcceptedConnectionChannelInitializer clientChannelHandler = ((NettyHttpServer)this.server).getClientChannelHandler();
        MatcherAssert.assertThat((String)"There are still open connections, expected none", (Object)clientChannelHandler.waitForConnectionsToBeClosed("server", Long.valueOf(1000L), TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
    }

    private static class InputStreamRequestProducer
    extends BasicRequestProducer {
        private static final int INITIAL_BUFFER_SIZE = 1024;

        public InputStreamRequestProducer(HttpRequest request, final InputStream inputStream, ContentType contentType, Executor executor) {
            super(request, (AsyncEntityProducer)new AbstractClassicEntityProducer(1024, contentType, executor){

                protected void produceData(ContentType contentType, OutputStream outputStream) throws IOException {
                    inputStream.transferTo(outputStream);
                }
            });
        }
    }
}

