/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.streaming;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.service.http.netty.impl.server.ChannelPromises;
import org.mule.service.http.netty.impl.server.HttpWriter;
import org.mule.service.http.netty.impl.streaming.StatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveEntitySender {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveEntitySender.class);
    private final ChannelHandlerContext ctx;
    private final Runnable beforeWrite;
    private final StatusCallback statusCallback;
    private final HttpWriter writer;
    private final HttpEntity entity;

    public ReactiveEntitySender(HttpEntity entity, ChannelHandlerContext ctx, Runnable beforeWrite, StatusCallback statusCallback, HttpWriter writer) {
        if (!entity.isReactive()) {
            throw new IllegalArgumentException("HTTP Entity does not allow reactive consumption");
        }
        this.ctx = ctx;
        this.writer = writer;
        this.beforeWrite = beforeWrite;
        this.statusCallback = statusCallback;
        this.entity = entity;
    }

    public void start() throws IOException {
        this.entity.onData(buffer -> {
            this.beforeWrite.run();
            LOGGER.debug("About to send entity data");
            this.writer.writeContent(Unpooled.wrappedBuffer((ByteBuffer)buffer), false, ChannelPromises.promiseToCallback(this.ctx, this.statusCallback, false));
        });
        this.entity.onComplete((trailers, throwable) -> {
            this.beforeWrite.run();
            LOGGER.debug("About to send {} trailers", (Object)trailers.size());
            if (trailers.isEmpty()) {
                this.writer.writeContent(Unpooled.EMPTY_BUFFER, true, ChannelPromises.promiseToCallback(this.ctx, this.statusCallback, true));
            } else {
                this.writer.writeTrailers((MultiMap<String, String>)trailers, ChannelPromises.promiseToCallback(this.ctx, this.statusCallback, true));
            }
        });
    }
}

