/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.qameta.allure.Feature;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.tck.junit5.DynamicPort;

@Feature(value="HTTP/2 Support")
public abstract class AbstractHttp2ClientServerTestCase
extends AbstractHttpServiceTestCase {
    @DynamicPort(systemProperty="http.port")
    private Integer port;
    protected HttpServer server;
    protected HttpClient client;

    public AbstractHttp2ClientServerTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setUp() throws Exception {
        HttpServerConfiguration.Builder serverConfigBuilder = new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.intValue()).setName("HTTP/2 Server").setHttp1Config(new Http1ProtocolConfig(false)).setHttp2Config(new Http2ProtocolConfig(true));
        this.server = this.service.getServerFactory().create(this.configureServer(serverConfigBuilder).build());
        this.server.start();
        HttpClientConfiguration.Builder clientConfigBuilder = new HttpClientConfiguration.Builder().setName("HTTP/2 Client").setHttp1Config(new Http1ProtocolConfig(false)).setHttp2Config(new Http2ProtocolConfig(true));
        this.client = this.service.getClientFactory().create(this.configureClient(clientConfigBuilder).build());
        this.client.start();
    }

    protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder serverConfigBuilder) {
        return serverConfigBuilder;
    }

    protected HttpClientConfiguration.Builder configureClient(HttpClientConfiguration.Builder clientConfigBuilder) {
        return clientConfigBuilder;
    }

    @AfterEach
    void tearDown() {
        if (this.server != null) {
            this.server.stop();
            this.server.dispose();
        }
        if (this.client != null) {
            this.client.stop();
        }
    }
}

