/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.message;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.FeedableHttpEntity;
import org.mule.service.http.netty.impl.message.ReactorNettyResponseWrapper;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import reactor.netty.http.client.HttpClientResponse;

@ExtendWith(value={MockitoExtension.class})
class ReactorNettyResponseWrapperTestCase
extends AbstractHttpTestCase {
    @Mock
    private HttpClientResponse reactorNettyResponse;
    @Mock
    private FeedableHttpEntity body;

    ReactorNettyResponseWrapperTestCase() {
    }

    @Test
    void status() {
        this.setUpStatus();
        ReactorNettyResponseWrapper muleResponse = new ReactorNettyResponseWrapper(this.reactorNettyResponse, this.body);
        MatcherAssert.assertThat((Object)muleResponse.getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)muleResponse.getReasonPhrase(), (Matcher)Matchers.is((Object)"OK"));
    }

    @Test
    void headersIndividually() {
        this.setUpHeaders();
        ReactorNettyResponseWrapper muleResponse = new ReactorNettyResponseWrapper(this.reactorNettyResponse, this.body);
        MatcherAssert.assertThat((Object)muleResponse.getHeaderValue("content-length"), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)muleResponse.getHeaderValueIgnoreCase("cOnTeNt-leNGth"), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)muleResponse.getHeaderValue("X-Header1"), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)muleResponse.getHeaderValueIgnoreCase("x-HEADER1"), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)muleResponse.getHeaderValues("x-header2"), (Matcher)Matchers.contains((Object[])new String[]{"value1", "value2"}));
        MatcherAssert.assertThat((Object)muleResponse.getHeaderValuesIgnoreCase("x-hEADer2"), (Matcher)Matchers.contains((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    void headerNames() {
        this.setUpHeaders();
        ReactorNettyResponseWrapper muleResponse = new ReactorNettyResponseWrapper(this.reactorNettyResponse, this.body);
        MatcherAssert.assertThat((Object)muleResponse.getHeaderNames(), (Matcher)Matchers.contains((Object[])new String[]{"Content-Length", "X-Header1", "X-Header2"}));
    }

    @Test
    void allHeaders() {
        this.setUpHeaders();
        ReactorNettyResponseWrapper muleResponse = new ReactorNettyResponseWrapper(this.reactorNettyResponse, this.body);
        MultiMap headers = muleResponse.getHeaders();
        MatcherAssert.assertThat((Object)((String)headers.get((Object)"content-length")), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((String)headers.get((Object)"X-Header1")), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)headers.getAll((Object)"x-header2"), (Matcher)Matchers.contains((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    void entity() {
        ReactorNettyResponseWrapper muleResponse = new ReactorNettyResponseWrapper(this.reactorNettyResponse, this.body);
        MatcherAssert.assertThat((Object)muleResponse.getEntity(), (Matcher)Matchers.is((Object)this.body));
    }

    void setUpStatus() {
        Mockito.when((Object)this.reactorNettyResponse.status()).thenReturn((Object)HttpResponseStatus.OK);
    }

    void setUpHeaders() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add("Content-Length", (Object)"0");
        headers.add("X-Header1", (Object)"value");
        headers.add("X-Header2", List.of("value1", "value2"));
        Mockito.when((Object)this.reactorNettyResponse.responseHeaders()).thenReturn((Object)headers);
    }
}

