/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.netty.channel.ChannelHandlerContext;
import io.qameta.allure.Issue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.service.http.netty.impl.server.ConnectionsCounterHandler;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.netty.utils.TestUtils;

@Issue(value="W-15867731")
public class ConnectionsCounterHandlerTestCase
extends AbstractHttpTestCase {
    private static final long HALF_SECOND_IN_NANOS = 500000000L;
    private static final long TWO_SECONDS_IN_NANOS = 2000000000L;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(1);
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private ChannelHandlerContext ctx;
    private final ConnectionsCounterHandler handler = new ConnectionsCounterHandler();

    @Test
    public void waitsWhenAChannelIsActive() throws Exception {
        long timeoutNanos = 500000000L;
        this.handler.channelActive(this.ctx);
        long nanosElapsed = TestUtils.measuringNanoseconds(() -> this.handler.waitForConnectionsToBeClosed("server", timeoutNanos, TimeUnit.NANOSECONDS));
        MatcherAssert.assertThat((Object)nanosElapsed, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeoutNanos)));
    }

    @Test
    public void doesNotWaitWhenNoChannelIsActive() throws Exception {
        int i;
        int numberOfConnections = 10;
        for (i = 0; i < numberOfConnections; ++i) {
            this.handler.channelActive(this.ctx);
        }
        for (i = 0; i < numberOfConnections; ++i) {
            this.handler.channelInactive(this.ctx);
        }
        long nanosElapsed = TestUtils.measuringNanoseconds(() -> this.handler.waitForConnectionsToBeClosed("server", 7L, TimeUnit.DAYS));
        MatcherAssert.assertThat((Object)nanosElapsed, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(500000000L)));
    }

    @Test
    public void lastChannelInactiveCallbackUnblocksTheWait() throws Exception {
        this.handler.channelActive(this.ctx);
        Latch timeMeasurementStarted = new Latch();
        Future<Long> elapsedNanosFuture = executorService.submit(() -> TestUtils.measuringNanoseconds(() -> {
            timeMeasurementStarted.release();
            this.handler.waitForConnectionsToBeClosed("server", 7L, TimeUnit.DAYS);
        }));
        timeMeasurementStarted.await();
        Thread.sleep(TimeUnit.NANOSECONDS.toMillis(500000000L));
        this.handler.channelInactive(this.ctx);
        MatcherAssert.assertThat((Object)elapsedNanosFuture.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(500000000L)));
        MatcherAssert.assertThat((Object)elapsedNanosFuture.get(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(2000000000L)));
    }

    @Test
    public void zeroTimeoutMeansNoWait() throws Exception {
        this.handler.channelActive(this.ctx);
        Long elapsedNanos = TestUtils.measuringNanoseconds(() -> this.handler.waitForConnectionsToBeClosed("server", 0L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)elapsedNanos, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(500000000L)));
    }

    @Test
    public void interruptingTheThreadUnblocksTheWait() throws Exception {
        this.handler.channelActive(this.ctx);
        Thread thread = new Thread(() -> this.handler.waitForConnectionsToBeClosed("server", 7L, TimeUnit.DAYS));
        thread.start();
        thread.interrupt();
        long nanosElapsed = TestUtils.measuringNanoseconds(thread::join);
        MatcherAssert.assertThat((Object)nanosElapsed, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(500000000L)));
    }

    @Test
    public void waitLessThanOneMillisecond() throws Exception {
        this.handler.channelActive(this.ctx);
        long lessThanOneMillisecondInNanos = TimeUnit.MILLISECONDS.toNanos(1L) - 1L;
        long nanosElapsed = TestUtils.measuringNanoseconds(() -> this.handler.waitForConnectionsToBeClosed("server", lessThanOneMillisecondInNanos, TimeUnit.NANOSECONDS));
        MatcherAssert.assertThat((Object)nanosElapsed, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(10L)));
    }
}

