/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.message.content;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.Feedable;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;

public class OnlyTrailersFeedable implements Feedable {

  private final CompletableFuture<MultiMap<String, String>> futureTrailers;

  public OnlyTrailersFeedable(CompletableFuture<MultiMap<String, String>> futureTrailers) {
    this.futureTrailers = futureTrailers;
  }

  @Override
  public void feed(ByteBuffer data) {}

  @Override
  public void error(Exception exception) {
    futureTrailers.completeExceptionally(exception);
  }

  @Override
  public void completeWithTrailers(MultiMap<String, String> trailers) {
    futureTrailers.complete(trailers);
  }
}
