/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.message.content;

import static org.mule.runtime.api.util.MultiMap.emptyMultiMap;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.Feedable;
import org.mule.service.http.netty.impl.streaming.CancelableOutputStream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;

public class StreamAndFutureFeedable implements Feedable {

  private final CancelableOutputStream dataSink;
  private final CompletableFuture<MultiMap<String, String>> futureTrailers;

  public StreamAndFutureFeedable(CancelableOutputStream dataSink,
                                 CompletableFuture<MultiMap<String, String>> futureTrailers) {
    this.dataSink = dataSink;
    this.futureTrailers = futureTrailers;
  }

  @Override
  public void feed(ByteBuffer data) throws IOException {
    byte[] bytes = new byte[data.remaining()];
    data.get(bytes);
    dataSink.write(bytes, 0, bytes.length);
  }

  @Override
  public void error(Exception exception) {
    dataSink.cancel(exception);
  }

  @Override
  public void complete() throws IOException {
    completeWithTrailers(emptyMultiMap());
  }

  @Override
  public void completeWithTrailers(MultiMap<String, String> trailers) throws IOException {
    futureTrailers.complete(trailers);
    dataSink.close();
  }
}
