/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.util;

import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.service.http.netty.impl.util.NettyUtils;
import reactor.netty.internal.shaded.reactor.pool.PoolAcquireTimeoutException;

public class ReactorNettyUtils {
    public static Exception onErrorMap(Throwable error) {
        if (NettyUtils.shouldWrapAsRemotelyClosed(error)) {
            return new IOException("Remotely closed", error);
        }
        if (error instanceof ReadTimeoutException) {
            return new TimeoutException("Timeout exceeded");
        }
        if (error instanceof URISyntaxException) {
            return new IllegalArgumentException(error);
        }
        if (error instanceof PoolAcquireTimeoutException) {
            return new IOException("Connection limit exceeded, cannot process request", error);
        }
        if (error instanceof UnknownHostException) {
            return new ConnectionException("Connection Failed. Unresolved Address.", error);
        }
        return (Exception)error;
    }
}

