/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.message.content;

import org.mule.runtime.http.api.domain.entity.EntityFactory;
import org.mule.runtime.http.api.domain.entity.FeedableHttpEntity;

public class NettyEntityFactory implements EntityFactory {

  @Override
  public FeedableHttpEntity feedable() {
    return new NettyFeedableHttpEntity();
  }

  @Override
  public FeedableHttpEntity feedable(long knownLength) {
    return new NettyFeedableHttpEntity(knownLength);
  }
}
