/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.module.apikit.metadata.internal.MetadataBuilderImpl;
import org.mule.module.apikit.metadata.internal.model.ApplicationModelWrapper;
import org.mule.module.apikit.metadata.internal.model.Flow;
import org.mule.module.apikit.metadata.utils.MockedApplicationModel;
import org.mule.module.apikit.metadata.utils.TestNotifier;
import org.mule.module.apikit.metadata.utils.TestResourceLoader;
import org.mule.runtime.apikit.metadata.api.Metadata;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.config.internal.model.ApplicationModel;

public class AbstractMetadataTestCase {
    protected static final String RAML = "RAML";
    private static final PathMatcher API_MATCHER = FileSystems.getDefault().getPathMatcher("glob:app.xml");

    protected static List<File> scanApps() throws IOException, URISyntaxException {
        URI baseFolder = AbstractMetadataTestCase.class.getResource("").toURI();
        return AbstractMetadataTestCase.scan(baseFolder);
    }

    protected static List<File> scan(URI resources) throws IOException {
        return Files.walk(Paths.get(resources), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && API_MATCHER.matches(path.getFileName())).map(Path::toFile).collect(Collectors.toList());
    }

    protected static ApplicationModel createApplicationModel(File app) throws Exception {
        MockedApplicationModel.Builder builder = new MockedApplicationModel.Builder();
        builder.addConfig("apiKitSample", app);
        MockedApplicationModel mockedApplicationModel = builder.build();
        return mockedApplicationModel.getApplicationModel();
    }

    protected static List<Flow> findFlows(File app) throws Exception {
        ApplicationModel applicationModel = AbstractMetadataTestCase.createApplicationModel(app);
        return ApplicationModelWrapper.findFlows((ApplicationModel)applicationModel).stream().filter(flow -> AbstractMetadataTestCase.isApikitFlow(flow)).collect(Collectors.toList());
    }

    private static boolean isApikitFlow(Flow flow) {
        String name = flow.getName();
        return name.startsWith("get:") || name.startsWith("post:") || name.startsWith("put:") || name.startsWith("delete:") || name.startsWith("head:") || name.startsWith("patch:") || name.startsWith("options:") || name.startsWith("trace:") || name.startsWith("connect:");
    }

    private static boolean hasMetadata(ApplicationModel applicationModel, Flow flow) {
        try {
            return AbstractMetadataTestCase.getMetadata(applicationModel, flow).isPresent();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static Optional<FunctionType> getMetadata(Metadata metadata, Flow flow) {
        return metadata.getMetadataForFlow(flow.getName());
    }

    protected static Optional<FunctionType> getMetadata(ApplicationModel applicationModel, Flow flow) throws Exception {
        Metadata metadata = new MetadataBuilderImpl().withApplicationModel(applicationModel).withResourceLoader((ResourceLoader)new TestResourceLoader()).withNotifier((Notifier)new TestNotifier()).build();
        return metadata.getMetadataForFlow(flow.getName());
    }

    protected static String metadataToString(String parser, FunctionType functionType) {
        return new MetadataTypeWriter().toString((MetadataType)functionType);
    }

    protected File goldenFile(Flow flow, File app, String parser) {
        String fileName = flow.getName().replace("\\", "").replace(":", "-") + ".out";
        File parserFolder = new File(app.getParentFile(), parser.toLowerCase());
        return new File(parserFolder, fileName);
    }

    protected static String readFile(Path path) {
        try {
            return new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Path createGoldenFile(File goldenFile, String content) throws IOException {
        String srcPath = goldenFile.getPath().replace("target/test-classes", "src/test/resources");
        Path goldenPath = Paths.get(srcPath, new String[0]);
        System.out.println("*** Create Golden " + goldenPath);
        Path parent = goldenPath.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectory(parent, new FileAttribute[0]);
        }
        return Files.write(goldenPath, content.getBytes("UTF-8"), new OpenOption[0]);
    }
}

