/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.mule.module.apikit.metadata.internal.MetadataBuilderImpl;
import org.mule.module.apikit.metadata.utils.MockedApplicationModel;
import org.mule.module.apikit.metadata.utils.TestNotifier;
import org.mule.module.apikit.metadata.utils.TestResourceLoader;
import org.mule.runtime.apikit.metadata.api.Metadata;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.config.internal.model.ApplicationModel;

public class MetadataModuleTestCase {
    @Test
    public void testBasicMetadataModule() throws Exception {
        TestResourceLoader resourceLoader = new TestResourceLoader();
        TestNotifier notifier = new TestNotifier();
        ApplicationModel applicationModel = this.createApplicationModel("org/mule/module/apikit/metadata/flow-mappings/app.xml");
        MatcherAssert.assertThat((Object)applicationModel, (Matcher)IsNull.notNullValue());
        Metadata metadata = new MetadataBuilderImpl().withApplicationModel(applicationModel).withResourceLoader((ResourceLoader)resourceLoader).withNotifier((Notifier)notifier).build();
        Optional createNewBookFlow = metadata.getMetadataForFlow("createNewBook");
        Optional getAllBooks = metadata.getMetadataForFlow("get:\\books:router-config");
        Optional flowMappingDoesNotExist = metadata.getMetadataForFlow("flowMappingDoesNotExist");
        Optional petshopApiGetCustomers = metadata.getMetadataForFlow("get:\\customers\\pets:petshop-api");
        Optional petShopApiCreateCustomer = metadata.getMetadataForFlow("post:\\customers:petshop-api");
        MatcherAssert.assertThat((Object)createNewBookFlow.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)getAllBooks.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)flowMappingDoesNotExist.isPresent(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)petShopApiCreateCustomer.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)petshopApiGetCustomers.isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void singleApiWithFlowsWithoutConfigRef() throws Exception {
        TestResourceLoader resourceLoader = new TestResourceLoader();
        TestNotifier notifier = new TestNotifier();
        ApplicationModel applicationModel = this.createApplicationModel("org/mule/module/apikit/metadata/single-api-with-no-name/app.xml");
        MatcherAssert.assertThat((Object)applicationModel, (Matcher)IsNull.notNullValue());
        Metadata metadata = new MetadataBuilderImpl().withApplicationModel(applicationModel).withResourceLoader((ResourceLoader)resourceLoader).withNotifier((Notifier)notifier).build();
        Optional getAllCustomersPets = metadata.getMetadataForFlow("get:\\customers\\pets");
        Optional createCustomer = metadata.getMetadataForFlow("post:\\customers");
        MatcherAssert.assertThat((Object)getAllCustomersPets.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)createCustomer.isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void ramlApplicationInRaml08() throws Exception {
        TestResourceLoader resourceLoader = new TestResourceLoader();
        TestNotifier notifier = new TestNotifier();
        ApplicationModel applicationModel = this.createApplicationModel("org/mule/module/apikit/metadata/api-in-raml08/app.xml");
        MatcherAssert.assertThat((Object)applicationModel, (Matcher)IsNull.notNullValue());
        Metadata metadata = new MetadataBuilderImpl().withApplicationModel(applicationModel).withResourceLoader((ResourceLoader)resourceLoader).withNotifier((Notifier)notifier).build();
        Optional putResources = metadata.getMetadataForFlow("put:\\resources:application\\json:router-config");
        Optional getResources = metadata.getMetadataForFlow("get:\\resources:router-config");
        Optional postResources = metadata.getMetadataForFlow("post:\\resources:router-config");
        Optional postUrlEncoded = metadata.getMetadataForFlow("post:\\url-encoded:application\\x-www-form-urlencoded:router-config");
        Optional postMultipart = metadata.getMetadataForFlow("post:\\multipart:multipart\\form-data:router-config");
        MatcherAssert.assertThat((Object)putResources.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)getResources.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)postResources.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)postUrlEncoded.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)postMultipart.isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testNotifyingOnlyInfoMesages() throws Exception {
        TestResourceLoader resourceLoader = new TestResourceLoader();
        TestNotifier notifier = new TestNotifier();
        ApplicationModel applicationModel = this.createApplicationModel("org/mule/module/apikit/metadata/api-in-raml08/app.xml");
        MatcherAssert.assertThat((Object)applicationModel, (Matcher)IsNull.notNullValue());
        Metadata metadata = new MetadataBuilderImpl().withApplicationModel(applicationModel).withResourceLoader((ResourceLoader)resourceLoader).withNotifier((Notifier)notifier).build();
        MetadataModuleTestCase.assertNotifierMessages(notifier, 0, 0, 0, 0);
        metadata.getMetadataForFlow("get:\\resources:router-config");
        MetadataModuleTestCase.assertNotifierMessages(notifier, 0, 0, 0, 0);
    }

    @Test
    public void testNotifyingOnlyErrorMessages() throws Exception {
        TestResourceLoader resourceLoader = new TestResourceLoader();
        TestNotifier notifier = new TestNotifier();
        ApplicationModel model = this.createApplicationModel("org/mule/module/apikit/metadata/invalid-raml-file-location/app.xml");
        MatcherAssert.assertThat((Object)model, (Matcher)IsNull.notNullValue());
        Metadata metadata = new MetadataBuilderImpl().withApplicationModel(model).withResourceLoader((ResourceLoader)resourceLoader).withNotifier((Notifier)notifier).build();
        MetadataModuleTestCase.assertNotifierMessages(notifier, 0, 0, 0, 0);
        metadata.getMetadataForFlow("get:\\flow1:router-config");
        MetadataModuleTestCase.assertNotifierMessages(notifier, 1, 0, 0, 0);
        metadata.getMetadataForFlow("get:\\flow2:router-config");
        MetadataModuleTestCase.assertNotifierMessages(notifier, 1, 0, 0, 0);
        metadata.getMetadataForFlow("get:\\flow3:router-config");
        MetadataModuleTestCase.assertNotifierMessages(notifier, 1, 0, 0, 0);
    }

    private ApplicationModel createApplicationModel(String resourceName) throws Exception {
        MockedApplicationModel.Builder builder = new MockedApplicationModel.Builder();
        builder.addConfig("apiKitSample", this.getClass().getClassLoader().getResourceAsStream(resourceName));
        MockedApplicationModel mockedApplicationModel = builder.build();
        return mockedApplicationModel.getApplicationModel();
    }

    private static void assertNotifierMessages(TestNotifier notifier, int error, int warning, int info, int debug) {
        MatcherAssert.assertThat((Object)notifier.messages("error").size(), (Matcher)Is.is((Object)error));
        MatcherAssert.assertThat((Object)notifier.messages("warn").size(), (Matcher)Is.is((Object)warning));
        MatcherAssert.assertThat((Object)notifier.messages("info").size(), (Matcher)Is.is((Object)info));
        MatcherAssert.assertThat((Object)notifier.messages("debug").size(), (Matcher)Is.is((Object)debug));
    }
}

