/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.metadata.api.model.FunctionType;
import org.mule.module.apikit.metadata.AbstractMetadataTestCase;
import org.mule.module.apikit.metadata.internal.model.Flow;
import org.mule.runtime.config.internal.model.ApplicationModel;

@RunWith(value=Parameterized.class)
public class MetadataTestCase
extends AbstractMetadataTestCase {
    private String parser;
    private File app;
    private Flow flow;

    public MetadataTestCase(String parser, String folderName, File app, Flow flow) {
        this.parser = parser;
        this.app = app;
        this.flow = flow;
    }

    @Test
    public void checkMetadata() throws Exception {
        File goldenFile = this.goldenFile(this.flow, this.app, this.parser);
        ApplicationModel applicationModel = MetadataTestCase.createApplicationModel(this.app);
        Assert.assertThat((Object)applicationModel, (Matcher)CoreMatchers.notNullValue());
        Optional<FunctionType> metadata = MetadataTestCase.getMetadata(applicationModel, this.flow);
        if (this.isInvalidFileLocation()) {
            Assert.assertThat((Object)metadata.isPresent(), (Matcher)CoreMatchers.is((Object)false));
            return;
        }
        Assert.assertThat((Object)metadata.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        String current = MetadataTestCase.metadataToString(this.parser, metadata.get());
        Path goldenPath = goldenFile.exists() ? goldenFile.toPath() : MetadataTestCase.createGoldenFile(goldenFile, current);
        String expected = MetadataTestCase.readFile(goldenPath);
        try {
            Assert.assertThat((String)String.format("Function metadata differ from expected. File: '%s'", goldenFile.getName()), (Object)current, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expected)));
        }
        catch (AssertionError error) {
            String name = goldenFile.getName();
            File folder = goldenFile.getParentFile();
            File newGoldenFile = new File(folder, name + ".fixed");
            MetadataTestCase.createGoldenFile(newGoldenFile, current);
            throw error;
        }
    }

    @Parameterized.Parameters(name="{0} -> {1}-{3}")
    public static Collection<Object[]> getData() throws IOException, URISyntaxException {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        MetadataTestCase.scanApps().forEach(app -> {
            try {
                String folderName = app.getParentFile().getName();
                MetadataTestCase.findFlows(app).forEach(flow -> parameters.add(new Object[]{"RAML", folderName, app, flow}));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return parameters;
    }

    private boolean isInvalidFileLocation() {
        return this.app.getPath().contains("invalid-raml-file-location");
    }
}

