/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.mule.module.apikit.metadata.internal.model.MetadataResolver;
import org.mule.module.apikit.metadata.internal.model.MetadataResolverFactory;
import org.mule.module.apikit.metadata.internal.raml.Parseable;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;
import org.mule.module.apikit.metadata.internal.raml.RamlV1Parser;
import org.mule.module.apikit.metadata.internal.raml.RamlV2Parser;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.core.api.util.StringUtils;

public class RamlHandler
implements MetadataResolverFactory {
    private final ResourceLoader resourceLoader;
    private final Notifier notifier;

    public RamlHandler(ResourceLoader resourceLoader, Notifier notifier) {
        this.resourceLoader = resourceLoader;
        this.notifier = notifier;
    }

    @Override
    public Optional<MetadataResolver> getMetadataResolver(String apiDefinition) {
        return this.getApi(apiDefinition).map(raml -> new RamlApiWrapper((IRaml)raml, this.notifier));
    }

    private Optional<IRaml> getApi(String uri) {
        try {
            File file;
            if (StringUtils.isEmpty((String)uri)) {
                this.notifier.error("RAML document is undefined.");
                return Optional.empty();
            }
            URI resource = this.resourceLoader.getResource(uri);
            File file2 = file = resource != null ? new File(resource) : null;
            if (file == null) {
                this.notifier.error(String.format("RAML document '%s' not found.", uri));
                return Optional.empty();
            }
            String content = this.getRamlContent(file);
            Parseable parser = this.getParser(content);
            return Optional.of(parser.build(file, content));
        }
        catch (Exception e) {
            this.notifier.error(String.format("Error reading RAML document '%s'. Detail: %s", uri, e.getMessage()));
            return Optional.empty();
        }
    }

    private Parseable getParser(String ramlContent) {
        return RamlHandler.useParserV2(ramlContent) ? new RamlV2Parser() : new RamlV1Parser();
    }

    private String getRamlContent(File uri) throws IOException {
        try (FileInputStream is = new FileInputStream(uri);){
            String string = IOUtils.toString((InputStream)is);
            return string;
        }
    }

    private static boolean useParserV2(String content) {
        return Boolean.getBoolean("apikit.raml.parser.v2") || content.startsWith("#%RAML 1.0");
    }
}

