/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.io.File;
import org.mule.module.apikit.metadata.internal.raml.Parseable;
import org.mule.raml.implv2.v08.model.RamlImpl08V2;
import org.mule.raml.implv2.v10.model.RamlImpl10V2;
import org.mule.raml.interfaces.model.IRaml;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;

class RamlV2Parser
implements Parseable {
    RamlV2Parser() {
    }

    @Override
    public IRaml build(File ramlFile, String ramlContent) {
        CompositeResourceLoader resourceLoader = new CompositeResourceLoader(new ResourceLoader[]{new DefaultResourceLoader(), new FileResourceLoader(ramlFile.getParentFile().getPath())});
        RamlModelResult ramlModelResult = new RamlModelBuilder((ResourceLoader)resourceLoader).buildApi(ramlContent, ramlFile.getPath());
        return RamlV2Parser.wrapApiModel(ramlModelResult);
    }

    private static IRaml wrapApiModel(RamlModelResult ramlModelResult) {
        if (ramlModelResult.hasErrors()) {
            throw new RuntimeException("Invalid RAML descriptor.");
        }
        if (ramlModelResult.isVersion08()) {
            return new RamlImpl08V2(ramlModelResult.getApiV08());
        }
        return new RamlImpl10V2(ramlModelResult.getApiV10());
    }
}

