/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.utils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class MetadataFixer {
    private static final String FORMAT = "%s : %s";
    private static final String FORMAT_ARRAY = "%s : [%s]";
    public static final String ENUM = "@enum(";

    private MetadataFixer() {
    }

    public static String normalizeEnums(String value) {
        return value.contains(ENUM) ? MetadataFixer.normalize(value) : value;
    }

    private static String normalize(String value) {
        String[] lines = value.split("\n");
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            result.add(line.contains(ENUM) ? MetadataFixer.normalizeEnumLine(line) : line);
        }
        String newValue = result.stream().collect(Collectors.joining("\n"));
        return newValue;
    }

    private static String normalizeEnumLine(String line) {
        Pair<String, String> keyValue = MetadataFixer.keyValue(line);
        String key = (String)keyValue.getKey();
        String value = (String)keyValue.getValue();
        boolean endsWithComma = line.trim().endsWith(",");
        boolean isArray = MetadataFixer.isArray(value);
        if (endsWithComma) {
            value = value.substring(0, value.lastIndexOf(44));
        }
        if (isArray) {
            value = MetadataFixer.arrayValue(value);
        }
        value = MetadataFixer.fixEnumValue(value);
        String format = isArray ? FORMAT_ARRAY : FORMAT;
        String newLine = String.format(format, key, value) + (endsWithComma ? ", " : "");
        return newLine;
    }

    private static Pair<String, String> keyValue(String value) {
        int i = value.indexOf(" : ");
        return new Pair((Object)value.substring(0, i), (Object)value.substring(i + 3));
    }

    private static String fixEnumValue(String value) {
        int i = value.indexOf(" & ");
        if (i == -1) {
            return value;
        }
        String op1 = value.substring(0, i);
        String op2 = value.substring(i + 3);
        return op1.contains(ENUM) ? op1 + " & " + op2 : op2 + " & " + op1;
    }

    private static String arrayValue(String value) {
        return value.substring(value.indexOf(91) + 1, value.lastIndexOf(93));
    }

    private static boolean isArray(String value) {
        return value.trim().startsWith("[");
    }
}

