/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.mule.module.apikit.metadata.utils.ApplicationModelWrapper;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.api.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.api.dsl.processor.ConfigFile;
import org.mule.runtime.config.api.dsl.processor.ConfigLine;
import org.mule.runtime.config.api.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.module.extension.internal.config.ExtensionBuildingDefinitionProvider;
import org.w3c.dom.Document;

public class MockedApplicationModel
implements ApplicationModelWrapper {
    private final String name;
    private ApplicationModel applicationModel;
    private String typesData;

    private MockedApplicationModel(String name, ApplicationModel applicationModel, String typesData) {
        this.name = name;
        this.applicationModel = applicationModel;
        this.typesData = typesData;
    }

    public String getName() {
        return this.name;
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public static ApplicationModelWrapper load(String name, String content) throws Exception {
        return MockedApplicationModel.load(name, content, null);
    }

    public static ApplicationModelWrapper load(String name, String content, String typesData) throws Exception {
        Builder builder = new Builder();
        builder.addConfig(name, IOUtils.toInputStream((String)content));
        if (typesData != null) {
            builder.typesData(typesData);
        }
        return builder.build();
    }

    public static ApplicationModelWrapper load(String name, File appDir) throws Exception {
        return MockedApplicationModel.load(name, appDir, null, null);
    }

    public static ApplicationModelWrapper load(String name, File appDir, MuleContext muleContext) throws Exception {
        return MockedApplicationModel.load(name, appDir, null, muleContext);
    }

    public static ApplicationModelWrapper load(String name, File appDir, File typesDataFile) throws Exception {
        return MockedApplicationModel.load(name, appDir, typesDataFile, null);
    }

    public static ApplicationModelWrapper load(String name, File appDir, File typesDataFile, MuleContext muleContext) throws Exception {
        Builder builder = new Builder();
        builder.addConfig(name, new File(appDir, name));
        if (typesDataFile != null) {
            builder.typesData(typesDataFile);
        }
        if (muleContext != null) {
            builder.muleContext(muleContext);
        }
        return builder.build();
    }

    @Override
    public ComponentModel findRootComponentModel() {
        return this.getApplicationModel().getRootComponentModel();
    }

    @Override
    public Optional<ComponentModel> findNamedComponent(String name) {
        return this.getApplicationModel().findTopLevelNamedComponent(name);
    }

    @Override
    public Optional<String> findTypesData() {
        return Optional.ofNullable(this.typesData);
    }

    public static class Builder {
        private final SpiServiceRegistry serviceRegistry;
        private final XmlApplicationParser xmlApplicationParser;
        private final ArtifactConfig.Builder artifactConfigBuilder = new ArtifactConfig.Builder();
        private ResourceProvider resourceProvider;
        private MuleContext muleContext;
        private String typesData;

        public Builder() {
            this.serviceRegistry = new SpiServiceRegistry();
            this.xmlApplicationParser = new XmlApplicationParser((ServiceRegistry)this.serviceRegistry, Collections.emptyList());
        }

        public Builder muleContext(MuleContext muleContext) {
            Preconditions.checkNotNull((Object)muleContext);
            this.muleContext = muleContext;
            return this;
        }

        public Builder resourceProvider(ResourceProvider resourceProvider) {
            Preconditions.checkNotNull((Object)this.muleContext);
            this.resourceProvider = resourceProvider;
            return this;
        }

        public Builder typesData(String typesData) {
            Preconditions.checkNotNull((Object)typesData);
            this.typesData = typesData;
            return this;
        }

        public Builder typesData(File typesDataFile) throws IOException {
            Preconditions.checkNotNull((Object)typesDataFile);
            return this.typesData(IOUtils.toString((URL)typesDataFile.toURI().toURL()));
        }

        public Builder addConfig(String configName, String configData) {
            Preconditions.checkNotNull((Object)configName);
            Preconditions.checkNotNull((Object)configData);
            return this.addConfig(configName, IOUtils.toInputStream((String)configData));
        }

        public Builder addConfig(String configName, File configData) throws IOException {
            Preconditions.checkNotNull((Object)configName);
            Preconditions.checkNotNull((Object)configData);
            try (FileInputStream fileInputStream = new FileInputStream(configData);){
                Builder builder = this.addConfig(configName, fileInputStream);
                return builder;
            }
        }

        public Builder addConfig(String configName, InputStream configData) {
            Preconditions.checkNotNull((Object)configName);
            Preconditions.checkNotNull((Object)configData);
            this.artifactConfigBuilder.addConfigFile(new ConfigFile(configName, Collections.singletonList(this.loadConfigLines(configData).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to parse %s.", configName))))));
            return this;
        }

        private Optional<ConfigLine> loadConfigLines(InputStream inputStream) {
            Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument("config", inputStream);
            return this.xmlApplicationParser.parse(document.getDocumentElement());
        }

        private static ComponentBuildingDefinitionRegistry createComponentBuildingDefinitionRegistry(Set<ExtensionModel> extensionModels, ClassLoader classLoader) {
            SpiServiceRegistry serviceRegistry = new SpiServiceRegistry();
            ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = new ComponentBuildingDefinitionRegistry();
            serviceRegistry.lookupProviders(ComponentBuildingDefinitionProvider.class, classLoader).forEach(componentBuildingDefinitionProvider -> {
                if (componentBuildingDefinitionProvider instanceof ExtensionBuildingDefinitionProvider) {
                    ((ExtensionBuildingDefinitionProvider)componentBuildingDefinitionProvider).setExtensionModels(extensionModels);
                }
                componentBuildingDefinitionProvider.init();
                componentBuildingDefinitionProvider.getComponentBuildingDefinitions().forEach(arg_0 -> ((ComponentBuildingDefinitionRegistry)componentBuildingDefinitionRegistry).register(arg_0));
            });
            return componentBuildingDefinitionRegistry;
        }

        private ResourceProvider getResourceProvider() {
            return Optional.ofNullable(this.resourceProvider).orElse(s -> {
                throw new UnsupportedOperationException();
            });
        }

        public MockedApplicationModel build() throws Exception {
            Set<ExtensionModel> extensionModels = Optional.ofNullable(this.muleContext).map(m -> m.getExtensionManager().getExtensions()).orElse(Collections.emptySet());
            ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = Builder.createComponentBuildingDefinitionRegistry(extensionModels, this.muleContext != null ? this.muleContext.getClass().getClassLoader() : Thread.currentThread().getContextClassLoader());
            ApplicationModel applicationModel = new ApplicationModel(this.artifactConfigBuilder.build(), null, extensionModels, Collections.emptyMap(), Optional.empty(), Optional.of(componentBuildingDefinitionRegistry), false, this.getResourceProvider());
            return new MockedApplicationModel("", applicationModel, this.typesData);
        }
    }
}

