/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.amf;

import amf.client.model.domain.WebApi;
import java.util.Optional;
import org.mule.module.apikit.metadata.internal.amf.AmfHandler;
import org.mule.module.apikit.metadata.internal.amf.AmfWrapper;
import org.mule.module.apikit.metadata.internal.model.MetadataResolver;
import org.mule.module.apikit.metadata.internal.model.MetadataResolverFactory;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;
import org.mule.module.apikit.metadata.internal.raml.RamlHandler;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;

public class AutoHandler
implements MetadataResolverFactory {
    private ResourceLoader resourceLoader;
    private final Notifier notifier;

    public AutoHandler(ResourceLoader resourceLoader, Notifier notifier) {
        this.resourceLoader = resourceLoader;
        this.notifier = notifier;
    }

    @Override
    public Optional<MetadataResolver> getMetadataResolver(String apiDefinition) {
        AmfHandler amfHandler = new AmfHandler(this.resourceLoader, this.notifier);
        Optional<WebApi> webApi = amfHandler.getApi(apiDefinition);
        if (webApi.isPresent()) {
            return webApi.map(api -> new AmfWrapper((WebApi)api, this.notifier));
        }
        RamlHandler ramlHandler = new RamlHandler(this.resourceLoader, this.notifier);
        Optional<IRaml> iRaml = ramlHandler.getApi(apiDefinition);
        return iRaml.map(raml -> new RamlApiWrapper((IRaml)raml, this.notifier));
    }
}

