/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.model;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.FunctionType;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.ApikitConfig;
import org.mule.module.apikit.metadata.internal.model.ApplicationModelWrapper;
import org.mule.runtime.apikit.metadata.api.Metadata;
import org.mule.runtime.apikit.metadata.api.MetadataSource;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.config.internal.model.ApplicationModel;

public class MetadataModel
implements Metadata {
    private final ApplicationModelWrapper applicationModel;
    private final Map<String, String> httpStatus;
    private final Map<String, String> outboundHeaders;

    public MetadataModel(ApplicationModel model, ResourceLoader loader, Notifier notifier) {
        this.applicationModel = new ApplicationModelWrapper(model, loader, notifier);
        this.httpStatus = MetadataModel.loadHttpStatusVars(this.applicationModel);
        this.outboundHeaders = MetadataModel.loadOutboundHeaders(this.applicationModel);
    }

    public Optional<FunctionType> getMetadataForFlow(String flowName) {
        Optional<ApiCoordinate> coordinate = this.applicationModel.getApiCoordinate(flowName);
        if (!coordinate.isPresent()) {
            return Optional.empty();
        }
        Optional<ApikitConfig> config = this.applicationModel.getConfig(coordinate.get().getConfigName());
        if (!config.isPresent()) {
            return Optional.empty();
        }
        String httpStatusVar = this.httpStatus.get(config.get().getName());
        String outboundHeadersVar = this.outboundHeaders.get(config.get().getName());
        if (Strings.isNullOrEmpty((String)httpStatusVar) || Strings.isNullOrEmpty((String)outboundHeadersVar)) {
            return Optional.empty();
        }
        return config.flatMap(ApikitConfig::getMetadataResolver).flatMap(resolver -> resolver.getMetadataSource((ApiCoordinate)coordinate.get(), httpStatusVar, outboundHeadersVar)).flatMap(MetadataSource::getMetadata);
    }

    private static Map<String, String> loadOutboundHeaders(ApplicationModelWrapper modelWrapper) {
        HashMap<String, String> outboundHeaders = new HashMap<String, String>();
        modelWrapper.getConfigurations().forEach(c -> outboundHeaders.put(c.getName(), c.getOutputHeadersVarName()));
        return outboundHeaders;
    }

    private static Map<String, String> loadHttpStatusVars(ApplicationModelWrapper modelWrapper) {
        HashMap<String, String> httpStatusVars = new HashMap<String, String>();
        modelWrapper.getConfigurations().forEach(c -> httpStatusVars.put(c.getName(), c.getHttpStatusVarName()));
        return httpStatusVars;
    }
}

