/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.utils;

import java.util.Arrays;
import java.util.List;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNotifier
implements Notifier {
    public static final String ERROR = "error";
    public static final String DEBUG = "debug";
    public static final String INFO = "info";
    public static final String WARN = "warn";
    public MultiMap<String, String> messages = new MultiMap();
    public static final Logger logger = LoggerFactory.getLogger(TestNotifier.class);

    public void error(String message) {
        this.messages.put((Object)ERROR, (Object)message);
        TestNotifier.log(ERROR, message);
    }

    public void warn(String message) {
        this.messages.put((Object)WARN, (Object)message);
        TestNotifier.log(WARN, message);
    }

    public void info(String message) {
        this.messages.put((Object)INFO, (Object)message);
        logger.info(message);
    }

    public void debug(String message) {
        this.messages.put((Object)DEBUG, (Object)message);
        logger.debug(message);
    }

    public List<String> messages(String type) {
        return this.messages.getAll((Object)type);
    }

    private static void log(String level, String msg) {
        String text = level.toUpperCase() + ": " + msg;
        String separator = TestNotifier.repeatChar('*', text.length());
        System.out.println(separator);
        System.out.println(text);
        System.out.println(separator);
    }

    private static final String repeatChar(char c, int length) {
        char[] data = new char[length];
        Arrays.fill(data, c);
        return new String(data);
    }
}

