/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.mule.module.apikit.metadata.internal.raml.ParserWrapper;
import org.mule.module.apikit.metadata.internal.raml.ParserWrapperV1;
import org.mule.module.apikit.metadata.internal.raml.ParserWrapperV2;
import org.mule.raml.implv2.ParserV2Utils;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;

class ParserService {
    private ParserWrapper parserWrapper;

    ParserService(String ramlPath, ResourceLoader resourceLoader) {
        this.parserWrapper = this.parserWrapper(ramlPath, resourceLoader);
    }

    private boolean getParserVersion(String content) {
        return ParserV2Utils.useParserV2((String)content);
    }

    private String readResource(String ramlPath, ResourceLoader resourceLoader) {
        URI uri = resourceLoader.getResource(ramlPath);
        try {
            return IOUtils.toString((URI)uri);
        }
        catch (IOException e) {
            return "";
        }
    }

    private ParserWrapper parserWrapper(String ramlPath, ResourceLoader resourceLoader) {
        String content = this.readResource(ramlPath, resourceLoader);
        boolean isParserV2 = this.getParserVersion(content);
        return isParserV2 ? new ParserWrapperV2(ramlPath, content, resourceLoader) : new ParserWrapperV1(ramlPath, content, resourceLoader);
    }

    public IRaml build() {
        return this.parserWrapper.build();
    }
}

