/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.MetadataResolver;
import org.mule.module.apikit.metadata.internal.raml.FlowMetadata;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.mule.runtime.apikit.metadata.api.MetadataSource;
import org.mule.runtime.apikit.metadata.api.Notifier;

public class RamlApiWrapper
implements MetadataResolver {
    private final Map<String, IResource> ramlResources = new HashMap<String, IResource>();
    private final Map<String, IParameter> baseUriParameters;
    private final Map<String, String> consolidatedSchemas;
    private final Notifier notifier;

    public RamlApiWrapper(IRaml ramlApi, Notifier notifier) {
        this.collectResources(ramlApi.getResources(), ramlApi.getVersion());
        this.consolidatedSchemas = ramlApi.getConsolidatedSchemas();
        this.baseUriParameters = ramlApi.getBaseUriParameters();
        this.notifier = notifier;
    }

    private void collectResources(Map<String, IResource> resources, String version) {
        resources.values().forEach(resource -> {
            this.ramlResources.put(resource.getResolvedUri(version), (IResource)resource);
            this.collectResources(resource.getResources(), version);
        });
    }

    @Override
    public Optional<MetadataSource> getMetadataSource(ApiCoordinate coordinate, String httpStatusVar, String outboundHeadersVar) {
        return Optional.ofNullable(this.ramlResources.get(coordinate.getResource())).map(resource -> resource.getAction(coordinate.getMethod())).map(action -> new FlowMetadata(this, (IAction)action, coordinate, this.baseUriParameters, httpStatusVar, outboundHeadersVar, this.notifier));
    }

    Map<String, String> getConsolidatedSchemas() {
        return this.consolidatedSchemas;
    }
}

