/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.util.Optional;
import org.mule.module.apikit.metadata.internal.model.MetadataResolver;
import org.mule.module.apikit.metadata.internal.model.MetadataResolverFactory;
import org.mule.module.apikit.metadata.internal.raml.ParserService;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.core.api.util.StringUtils;

public class RamlHandler
implements MetadataResolverFactory {
    private final ResourceLoader resourceLoader;
    private final Notifier notifier;

    public RamlHandler(ResourceLoader resourceLoader, Notifier notifier) {
        this.resourceLoader = resourceLoader;
        this.notifier = notifier;
    }

    @Override
    public Optional<MetadataResolver> getMetadataResolver(String apiDefinition) {
        return this.getApi(apiDefinition).map(raml -> new RamlApiWrapper((IRaml)raml, this.notifier));
    }

    public Optional<IRaml> getApi(String uri) {
        try {
            if (StringUtils.isEmpty((String)uri)) {
                this.notifier.error("RAML document is undefined.");
                return Optional.empty();
            }
            ParserService parserService = new ParserService(uri, this.resourceLoader);
            return Optional.of(parserService.build());
        }
        catch (Exception e) {
            this.notifier.error(String.format("Error reading RAML document '%s'. Detail: %s", uri, e.getMessage()));
            return Optional.empty();
        }
    }
}

