/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.amf;

import amf.client.model.domain.WebApi;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.mule.amf.impl.ParserWrapperAmf;
import org.mule.module.apikit.metadata.internal.amf.AmfWrapper;
import org.mule.module.apikit.metadata.internal.model.MetadataResolver;
import org.mule.module.apikit.metadata.internal.model.MetadataResolverFactory;
import org.mule.raml.interfaces.loader.ResourceLoader;
import org.mule.raml.interfaces.model.api.ApiRef;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.core.api.util.StringUtils;

public class AmfHandler
implements MetadataResolverFactory {
    private final org.mule.runtime.apikit.metadata.api.ResourceLoader resourceLoader;
    private final Notifier notifier;

    public AmfHandler(org.mule.runtime.apikit.metadata.api.ResourceLoader resourceLoader, Notifier notifier) {
        this.resourceLoader = resourceLoader;
        this.notifier = notifier;
    }

    @Override
    public Optional<MetadataResolver> getMetadataResolver(String apiDefinition) {
        return this.getApi(apiDefinition).map(webApi -> new AmfWrapper((WebApi)webApi, this.notifier));
    }

    Optional<WebApi> getApi(String apiDefinition) {
        ParserWrapperAmf parserWrapper;
        if (StringUtils.isEmpty((String)apiDefinition)) {
            this.notifier.error("API definition is undefined using AMF parser.");
            return Optional.empty();
        }
        try {
            ApiRef apiRef = ApiRef.create((String)apiDefinition, (ResourceLoader)AmfHandler.adaptResourceLoader(this.resourceLoader));
            parserWrapper = ParserWrapperAmf.create((ApiRef)apiRef, (boolean)true);
        }
        catch (Exception e) {
            this.notifier.error(String.format("Error reading API definition '%s' using AMF parser. Detail: %s", apiDefinition, e.getMessage()));
            return Optional.empty();
        }
        this.notifier.info(String.format("Metadata for API definition '%s' was generated using AMF parser.", apiDefinition));
        return Optional.of(parserWrapper.getWebApi());
    }

    private static ResourceLoader adaptResourceLoader(final org.mule.runtime.apikit.metadata.api.ResourceLoader resourceLoader) {
        return new ResourceLoader(){

            public URI getResource(String path) {
                return resourceLoader.getResource(path);
            }

            public InputStream getResourceAsStream(String relativePath) {
                return resourceLoader.getResourceAsStream(relativePath);
            }
        };
    }
}

