/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.mule.module.apikit.metadata.utils.ApplicationModel;
import org.mule.module.apikit.metadata.utils.MetadataProviderUtil;
import org.mule.module.apikit.metadata.utils.MuleAppUtil;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.RuntimeExtensionModelProvider;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.xml.parser.ConfigFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockedApplicationModel
implements ApplicationModel {
    private static final transient Logger logger = LoggerFactory.getLogger(MockedApplicationModel.class);
    private final String name;
    private final URI baseURI;
    private org.mule.runtime.config.internal.model.ApplicationModel applicationModel;
    private List<String> typesDataList;

    private MockedApplicationModel(String name, org.mule.runtime.config.internal.model.ApplicationModel applicationModel, List<String> typesDataList, URI baseURI) {
        this.name = name;
        this.applicationModel = applicationModel;
        this.typesDataList = new ArrayList<String>();
        this.typesDataList.addAll(typesDataList);
        this.baseURI = baseURI;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Optional<URI> findResource(String resource) {
        if (this.baseURI == null) {
            return Optional.empty();
        }
        return Optional.of(this.baseURI.resolve(resource));
    }

    @Override
    public org.mule.runtime.config.internal.model.ApplicationModel getMuleApplicationModel() {
        return this.applicationModel;
    }

    public static ApplicationModel load(String name, String content) throws Exception {
        return MockedApplicationModel.load(name, content, null);
    }

    public static ApplicationModel load(String name, String content, String typesData) throws Exception {
        Builder builder = new Builder();
        builder.addConfig(name, IOUtils.toInputStream((String)content));
        if (typesData != null) {
            builder.typesData(typesData);
        }
        return builder.build();
    }

    public static ApplicationModel load(String name, File appDir) throws Exception {
        return MockedApplicationModel.load(name, appDir, null, null);
    }

    public static ApplicationModel load(String name, File appDir, MuleContext muleContext) throws Exception {
        return MockedApplicationModel.load(name, appDir, null, muleContext);
    }

    public static ApplicationModel load(String name, File appDir, File typesDataFile) throws Exception {
        return MockedApplicationModel.load(name, appDir, typesDataFile, null);
    }

    public static ApplicationModel load(String name, File appDir, File typesDataFile, MuleContext muleContext) throws Exception {
        Builder builder = new Builder();
        builder.addConfig(name, new File(appDir, name));
        if (typesDataFile != null) {
            builder.typesData(typesDataFile);
        }
        if (muleContext != null) {
            builder.muleContext(muleContext);
        }
        return builder.build();
    }

    @Override
    public ComponentModel findRootComponentModel() {
        return this.getMuleApplicationModel().getRootComponentModel();
    }

    @Override
    public Optional<ComponentModel> findNamedComponent(String name) {
        return this.getMuleApplicationModel().findTopLevelNamedComponent(name);
    }

    @Override
    public List<String> findTypesDataList() {
        return this.typesDataList;
    }

    public static class Builder {
        private final ArtifactConfig.Builder artifactConfigBuilder = new ArtifactConfig.Builder();
        private ResourceProvider resourceProvider;
        private MuleContext muleContext;
        private List<String> typesDataList = new ArrayList<String>();
        private URI baseURI;

        public Builder muleContext(MuleContext muleContext) {
            Preconditions.checkNotNull((Object)muleContext);
            this.muleContext = muleContext;
            return this;
        }

        public Builder resourceProvider(ResourceProvider resourceProvider) {
            Preconditions.checkNotNull((Object)this.muleContext);
            this.resourceProvider = resourceProvider;
            return this;
        }

        public Builder typesData(String typesData) {
            Preconditions.checkNotNull((Object)typesData);
            this.typesDataList.add(typesData);
            return this;
        }

        public Builder baseURI(URI baseURI) {
            Preconditions.checkNotNull((Object)baseURI);
            this.baseURI = baseURI;
            return this;
        }

        public Builder typesData(File typesDataFile) throws IOException {
            Preconditions.checkNotNull((Object)typesDataFile);
            return this.typesData(IOUtils.toString((URL)typesDataFile.toURI().toURL()));
        }

        public Builder addConfig(String configName, String configData) {
            Preconditions.checkNotNull((Object)configName);
            Preconditions.checkNotNull((Object)configData);
            return this.addConfig(configName, IOUtils.toInputStream((String)configData));
        }

        public Builder addConfig(String configName, File configData) throws IOException {
            Preconditions.checkNotNull((Object)configName);
            Preconditions.checkNotNull((Object)configData);
            try (FileInputStream fileInputStream = new FileInputStream(configData);){
                Builder builder = this.addConfig(configName, fileInputStream);
                return builder;
            }
        }

        public Builder addConfig(String configName, InputStream configData) {
            Preconditions.checkNotNull((Object)configName);
            Preconditions.checkNotNull((Object)configData);
            this.artifactConfigBuilder.addConfigFile(new ConfigFile(configName, Collections.singletonList(MuleAppUtil.loadConfigLines(configData).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to parse %s.", configName))))));
            return this;
        }

        private ResourceProvider getResourceProvider() {
            return Optional.ofNullable(this.resourceProvider).orElse(s -> {
                throw new UnsupportedOperationException();
            });
        }

        public MockedApplicationModel build() throws Exception {
            Set<ExtensionModel> extensionModels = Optional.ofNullable(this.muleContext).map(m -> m.getExtensionManager().getExtensions()).orElse(Collections.emptySet());
            org.mule.runtime.config.internal.model.ApplicationModel toolingApplicationModel = MuleAppUtil.loadApplicationModel(this.artifactConfigBuilder.build(), "", (Set<ExtensionModel>)ImmutableSet.builder().addAll(extensionModels).addAll(this.discoverRuntimeExtensionModels()).build(), Optional.of(MetadataProviderUtil.createComponentBuildingDefinitionRegistry(extensionModels, ComponentBuildingDefinitionProvider.class.getClassLoader())), false, this.getResourceProvider());
            logger.debug("Resolved locations for Tooling ApplicationModel:");
            toolingApplicationModel.executeOnEveryComponentTree(componentModel -> {
                if (componentModel.getComponentLocation() != null) {
                    logger.debug(String.format("Location: %s (%s)", componentModel.getComponentLocation().getLocation(), componentModel.getIdentifier()));
                }
            });
            if (this.muleContext != null) {
                logger.debug("Resolved locations from deployed application:");
                this.muleContext.getConfigurationComponentLocator().findAllLocations().stream().forEach(componentLocation -> logger.debug(String.format("Location: %s (%s)", componentLocation.getLocation(), componentLocation.getComponentIdentifier())));
            }
            return new MockedApplicationModel("", toolingApplicationModel, this.typesDataList, this.baseURI);
        }

        public Set<ExtensionModel> discoverRuntimeExtensionModels() {
            HashSet<ExtensionModel> extensionModels = new HashSet<ExtensionModel>();
            Collection runtimeExtensionModelProviders = new SpiServiceRegistry().lookupProviders(RuntimeExtensionModelProvider.class, Thread.currentThread().getContextClassLoader());
            for (RuntimeExtensionModelProvider runtimeExtensionModelProvider : runtimeExtensionModelProviders) {
                extensionModels.add(runtimeExtensionModelProvider.createExtensionModel());
            }
            return extensionModels;
        }
    }
}

