/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.CertificateFields;
import org.mule.module.apikit.metadata.internal.model.HttpRequestAttributesFields;
import org.mule.module.apikit.metadata.internal.raml.MetadataFactory;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.IResponse;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.mule.runtime.apikit.metadata.api.MetadataSource;
import org.mule.runtime.apikit.metadata.api.Notifier;

public class FlowMetadata
implements MetadataSource {
    private static final String PARAMETER_INPUT_METADATA = "inputMetadata";
    private final IAction action;
    private final ApiCoordinate coordinate;
    private final Map<String, IParameter> baseUriParameters;
    private final String httpStatusVar;
    private final String outboundHeadersVar;
    private final RamlApiWrapper api;
    private final Notifier notifier;

    public FlowMetadata(RamlApiWrapper api, IAction action, ApiCoordinate coordinate, Map<String, IParameter> baseUriParameters, String httpStatusVar, String outboundHeadersVar, Notifier notifier) {
        this.api = api;
        this.action = action;
        this.coordinate = coordinate;
        this.baseUriParameters = baseUriParameters;
        this.httpStatusVar = httpStatusVar;
        this.outboundHeadersVar = outboundHeadersVar;
        this.notifier = notifier;
    }

    public Optional<FunctionType> getMetadata() {
        MuleEventMetadataType inputEvent = this.inputMetadata(this.action, this.coordinate, this.baseUriParameters);
        MuleEventMetadataType outputEvent = this.outputMetadata(this.action, this.coordinate, this.outboundHeadersVar, this.httpStatusVar);
        FunctionTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).functionType();
        FunctionType function = builder.addParameterOf(PARAMETER_INPUT_METADATA, (MetadataType)inputEvent).returnType((MetadataType)outputEvent).build();
        return Optional.of(function);
    }

    private MuleEventMetadataType inputMetadata(IAction action, ApiCoordinate coordinate, Map<String, IParameter> baseUriParameters) {
        MessageMetadataType message = new MessageMetadataTypeBuilder().payload(this.getInputPayload(action, coordinate)).attributes((MetadataType)this.getInputAttributes(action, baseUriParameters)).build();
        return new MuleEventMetadataTypeBuilder().message(message).build();
    }

    private MuleEventMetadataType outputMetadata(IAction action, ApiCoordinate coordinate, String outboundHeadersVar, String httpStatusVar) {
        MessageMetadataType message = new MessageMetadataTypeBuilder().payload(this.getOutputPayload(action, coordinate)).build();
        return new MuleEventMetadataTypeBuilder().message(message).addVariable(outboundHeadersVar, (MetadataType)this.getOutputHeaders(action).build()).addVariable(httpStatusVar, MetadataFactory.stringMetadata()).build();
    }

    private ObjectTypeBuilder getOutputHeaders(IAction action) {
        Map<String, IParameter> headers = this.findFirstResponse(action).map(IResponse::getHeaders).orElse(Collections.emptyMap());
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        headers.forEach((name, value) -> builder.addField().key(name.toLowerCase()).value(value.getMetadata()).required(value.isRequired()));
        return builder;
    }

    private Optional<IResponse> findFirstResponse(IAction action) {
        Optional<IResponse> response = this.getResponse(action, "200");
        if (response.isPresent()) {
            return response;
        }
        return action.getResponses().keySet().stream().map(code -> this.getResponse(action, (String)code)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Optional<IResponse> getResponse(IAction action, String statusCode) {
        return Optional.ofNullable(action.getResponses().get(statusCode)).filter(IResponse::hasBody);
    }

    private ObjectTypeBuilder getQueryParameters(IAction action) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        action.getQueryParameters().forEach((key, value) -> builder.addField().key(key).value(value.getMetadata()).required(value.isRequired()));
        return builder;
    }

    private ObjectTypeBuilder getInputHeaders(IAction action) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        action.getHeaders().forEach((key, value) -> builder.addField().key(key).value(value.getMetadata()).required(value.isRequired()));
        return builder;
    }

    private ObjectType getInputAttributes(IAction action, Map<String, IParameter> baseUriParameters) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_CLIENT_CERTIFICATE.getName()).required(false).value(this.getClientCertificate());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_HEADERS.getName()).required(true).value((TypeBuilder)this.getInputHeaders(action));
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_LISTENER_PATH.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_METHOD.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_QUERY_PARAMS.getName()).required(true).value((TypeBuilder)this.getQueryParameters(action));
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_QUERY_STRING.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_RELATIVE_PATH.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_REMOTE_ADDRESS.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_REQUEST_PATH.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_REQUEST_URI.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_SCHEME.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_URI_PARAMS.getName()).required(true).value((TypeBuilder)this.getUriParameters(action, baseUriParameters));
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_VERSION.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_LOCAL_ADDRESS.getName()).required(true).value(MetadataFactory.stringMetadata());
        return builder.build();
    }

    private MetadataType getClientCertificate() {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        builder.addField().key(CertificateFields.CLIENT_CERTIFICATE_PUBLIC_KEY.getName()).value(MetadataFactory.objectMetadata());
        builder.addField().key(CertificateFields.CLIENT_CERTIFICATE_TYPE.getName()).value(MetadataFactory.stringMetadata());
        builder.addField().key(CertificateFields.CLIENT_CERTIFICATE_ENCODED.getName()).value(MetadataFactory.binaryMetadata());
        return builder.build();
    }

    private ObjectTypeBuilder getUriParameters(IAction action, Map<String, IParameter> baseUriParameters) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        baseUriParameters.forEach((name, parameter) -> builder.addField().key(name).value(parameter.getMetadata()).required(parameter.isRequired()));
        action.getResource().getResolvedUriParameters().forEach((name, parameter) -> builder.addField().key(name).value(parameter.getMetadata()).required(parameter.isRequired()));
        return builder;
    }

    private MetadataType getOutputPayload(IAction action, ApiCoordinate coordinate) {
        Optional<Collection> mimeTypes = this.findFirstResponse(action).map(response -> response.getBody().values());
        IMimeType mimeType = mimeTypes.isPresent() ? (IMimeType)mimeTypes.get().stream().findFirst().orElse(null) : null;
        return this.loadIOPayloadMetadata(mimeType, coordinate, this.api, "output");
    }

    private MetadataType getInputPayload(IAction action, ApiCoordinate coordinate) {
        IMimeType mimeType = null;
        if (action.hasBody()) {
            if (action.getBody().size() == 1) {
                mimeType = (IMimeType)action.getBody().values().iterator().next();
            } else if (coordinate.getMediaType() != null) {
                mimeType = (IMimeType)action.getBody().get(coordinate.getMediaType());
            }
        }
        return this.loadIOPayloadMetadata(mimeType, coordinate, this.api, "input");
    }

    private MetadataType loadIOPayloadMetadata(IMimeType mimeType, ApiCoordinate coordinate, RamlApiWrapper api, String payloadDescription) {
        try {
            return MetadataFactory.payloadMetadata(api, mimeType);
        }
        catch (Exception e) {
            this.notifier.warn(String.format("Error while trying to resolve %s payload metadata for flow '%s'.\nDetails: %s", payloadDescription, coordinate.getFlowName(), e.getMessage()));
            return MetadataFactory.defaultMetadata();
        }
    }
}

