/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.loader;

import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;

public class ExchangeResourceLoader
implements ResourceLoader {
    private File workingDir;
    private static final Pattern DEPENDENCY_PATH_PATTERN = Pattern.compile("^exchange_modules/|/exchange_modules/");

    public ExchangeResourceLoader(ResourceLoader resourceLoader, String rootFile) {
        URI rootPath = resourceLoader.getResource(rootFile);
        this.workingDir = rootPath != null ? new File(rootPath).getParentFile() : null;
    }

    public URI getResource(String relativePath) {
        Matcher matcher;
        if (Strings.isNullOrEmpty((String)relativePath)) {
            return null;
        }
        if (this.workingDir != null && this.workingDir.exists() && (matcher = DEPENDENCY_PATH_PATTERN.matcher(relativePath)).find()) {
            int dependencyIndex = relativePath.lastIndexOf(matcher.group(0));
            String resourceName = dependencyIndex <= 0 ? relativePath : relativePath.substring(dependencyIndex);
            return Paths.get(this.workingDir.getPath(), resourceName).toUri();
        }
        return null;
    }
}

