/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonExampleTypeLoader;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.metadata.xml.api.ModelFactory;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.metadata.xml.api.utils.XmlSchemaUtils;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;

class MetadataFactory {
    private static final String MIME_APPLICATION_JSON = "application/json";
    private static final String MIME_APPLICATION_XML = "application/xml";
    private static final String MIME_MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String MIME_APPLICATION_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final MetadataType DEFAULT_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).anyType().build();
    private static final MetadataType STRING_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();

    private MetadataFactory() {
    }

    public static MetadataType payloadMetadata(RamlApiWrapper api, @Nullable MimeType body) {
        if (body == null) {
            return MetadataFactory.defaultMetadata();
        }
        String type = body.getType();
        String schema = MetadataFactory.resolveSchema(api, body);
        String example = body.getExample();
        switch (type) {
            case "application/json": {
                return MetadataFactory.applicationJsonMetadata(schema, example);
            }
            case "application/xml": {
                return MetadataFactory.applicationXmlMetadata(schema, example);
            }
            case "application/x-www-form-urlencoded": {
                return MetadataFactory.formMetadata(body.getFormParameters());
            }
            case "multipart/form-data": {
                return MetadataFactory.formMetadata(body.getFormParameters());
            }
        }
        return MetadataFactory.defaultMetadata();
    }

    private static String resolveSchema(RamlApiWrapper api, MimeType body) {
        String schema = body.getSchema();
        if (api.getConsolidatedSchemas().containsKey(schema)) {
            schema = api.getConsolidatedSchemas().get(schema);
        }
        return schema;
    }

    private static MetadataType formMetadata(Map<String, List<Parameter>> formParameters) {
        return MetadataFactory.fromFormMetadata(formParameters);
    }

    private static MetadataType applicationXmlMetadata(String schema, String example) {
        if (schema != null) {
            return MetadataFactory.fromXSDSchema(schema, example);
        }
        if (example != null) {
            return MetadataFactory.fromXMLExample(example);
        }
        return MetadataFactory.defaultMetadata();
    }

    private static MetadataType applicationJsonMetadata(String schema, String example) {
        if (schema != null) {
            return MetadataFactory.fromJsonSchema(schema);
        }
        if (example != null) {
            return MetadataFactory.fromJsonExample(example);
        }
        return MetadataFactory.defaultMetadata();
    }

    public static MetadataType fromJsonSchema(String jsonSchema) {
        JsonTypeLoader jsonTypeLoader = new JsonTypeLoader(jsonSchema);
        Optional root = jsonTypeLoader.load(null);
        return root.orElse(MetadataFactory.defaultMetadata());
    }

    private static MetadataType fromJsonExample(String jsonExample) {
        JsonExampleTypeLoader jsonExampleTypeLoader = new JsonExampleTypeLoader(jsonExample);
        jsonExampleTypeLoader.setFieldRequirementDefault(false);
        Optional root = jsonExampleTypeLoader.load(null);
        return root.orElse(MetadataFactory.defaultMetadata());
    }

    public static MetadataType fromXSDSchema(String xsdSchema, String example) {
        Optional rootElementName = XmlSchemaUtils.getXmlSchemaRootElementName(Collections.singletonList(xsdSchema), (String)example);
        return rootElementName.map(qName -> {
            XmlTypeLoader xmlTypeLoader = new XmlTypeLoader(SchemaCollector.getInstance().addSchema("", xsdSchema));
            return xmlTypeLoader.load(qName.toString()).orElse(MetadataFactory.defaultMetadata());
        }).orElse(MetadataFactory.defaultMetadata());
    }

    public static MetadataType fromXMLExample(String xmlExample) {
        ModelFactory modelFactory = ModelFactory.fromExample((String)xmlExample);
        Optional metadata = new XmlTypeLoader(modelFactory).load(null);
        return metadata.orElse(MetadataFactory.defaultMetadata());
    }

    public static MetadataType fromFormMetadata(Map<String, List<Parameter>> formParameters) {
        ObjectTypeBuilder parameters = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        for (Map.Entry<String, List<Parameter>> entry : formParameters.entrySet()) {
            parameters.addField().key(entry.getKey()).value().anyType();
        }
        return parameters.build();
    }

    public static MetadataType defaultMetadata() {
        return DEFAULT_METADATA;
    }

    public static MetadataType stringMetadata() {
        return STRING_METADATA;
    }

    public static MetadataType objectMetadata() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().build();
    }

    public static MetadataType binaryMetadata() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).binaryType().build();
    }
}

